package bd_exercici;

import java.sql.*;

import java.io.*;
//import java.io.BufferedReader;
//import java.io.FileReader;

//import java.util.*;



public class BD
{
    protected String hostname;
    protected int port;
    protected String DBName;

    protected String login;
    protected String password;
    
    protected String URL; //jdbc:mysql://nomhost:3306/nomBD?user=usuari&password=clau;
    protected Connection conexio;

    protected boolean conectat = false;
    
    protected ResultSet resultats;
    
    public enum tipusBD { MYSQL, ACCESS }
    
    protected tipusBD tipus = tipusBD.MYSQL; //valueOf("MYSQL");
    
    //Constuctor per a mySQL y Access (amb String):
    public BD(String tipus, String hostname, int port, String DBName, String login, String password) throws Exception
    {
        tipus = tipus.toUpperCase();
        
        if (tipus.equals("MYSQL"))
        {
            this.conectaGeneric(hostname, port, DBName, login, password);
        }
        else
        {
            this.conectaAccess(DBName, login, password);
        }
    }
    
    //Constuctor per a mySQL y Access (amb enum):
    public BD(tipusBD tipus, String hostname, int port, String DBName, String login, String password) throws Exception
    {
        switch (tipus)
        {
            case MYSQL: //Si es mySQL:
                this.conectaGeneric(hostname, port, DBName, login, password);
                break;
            default: //...pero si es Access:
                this.conectaAccess(DBName, login, password);
        }
    }

    //Conecta a mySQL i altres semblants:
    private void conectaGeneric(String hostname, int port, String DBName, String login, String password) throws Exception
    {
        this.tipus = tipusBD.MYSQL; //valueOf("MYSQL");
        
        this.setHostname(hostname);
        this.setPort(port);
        this.setDBName(DBName);
        this.setLogin(login);
        this.setPassword(password);
        this.setURL();
        
        this.conecta();
    }
    
    //Conecta a Access per ODBC:
    private void conectaAccess(String DBName, String login, String password) throws Exception
    {
        this.tipus = tipusBD.ACCESS; //valueOf("ACCESS");
        
        this.setHostname(hostname);
        this.setPort(port);
        this.setDBName(DBName);
        this.setLogin(login);
        this.setPassword(password);
        this.setURL();
        
        this.conecta();
    }

    public void setAutoComit(boolean autoComit) throws Exception
    {
        this.conexio.setAutoCommit(autoComit);
    }
    
    public boolean getAutoComit() throws Exception
    {
        return this.conexio.getAutoCommit();
    }
    
    public void commit() throws Exception
    {
        this.conexio.commit();
    }
    
    public void rollback() throws Exception
    {
        this.conexio.rollback();
    }
    
    public void setHostname(String hostname)
    {
        this.hostname = hostname;
    }
    
    public String getHostname()
    {
        return this.hostname;
    }
    
    public void setPort(int port)
    {
        this.port = port;
    }
    
    public float getPort()
    {
        return this.port;
    }
    
    public void setDBName(String DBName)
    {
        this.DBName = DBName;
    }
    
    public String getDBName()
    {
        return this.DBName;
    }
    
    public void setLogin(String login)
    {
        this.login = login;
    }
    
    public String getLogin()
    {
        return this.login;
    }
    
    public void setPassword(String password)
    {
        this.password = password;
    }
    
    public String getPassword()
    {
        return this.password;
    }
    
    protected void setURL()
    {
        //Si es mySQL:
        if (this.tipus == tipusBD.MYSQL) //valueOf("MYSQL"))
        {
            //jdbc:mysql://nomhost:3306/nomBD?user=usuari&password=clau;
            this.URL = "jdbc:mysql://" + this.getHostname() + ":" + (int) this.getPort() + "/" + this.getDBName() + "?user=" + this.getLogin() + "&password=" + this.getPassword();
            //this.URL = "jdbc:mysql://" + this.getHostname() + "/" + this.getDBName();//?user=" + this.getLogin() + "&password=" + this.getPassword();
        }
        //...pero si es Access:
        else
        {
            this.URL = "jdbc:odbc:BDllibres";
        }
    }
    
    public String getURL()
    {
        return this.URL;
    }
    
    public void setConectat(boolean conectat)
    {
        this.conectat = conectat;
    }
    
    public boolean getConectat()
    {
        return this.conectat;
    }
    
    public void setResultats(ResultSet resultats)
    {
        this.resultats = resultats;
    }
    
    public ResultSet getResultats()
    {
        return this.resultats;
    }
            
    public boolean conecta() throws Exception //Ja que la he cridat des del constructor, podria fer-la privada a lo millor, pero la deixo publica pero si es vol tornar a conectar.
    {
        boolean conectat = false;
        
        //Si no esta conectat, conecta:
        if (!this.getConectat())
        {
            //Si es mySQL:
            if (this.tipus == tipusBD.MYSQL) { DriverManager.registerDriver(new com.mysql.jdbc.Driver()); }
            //...pero si es Access:
            else { Class.forName("sun.jdbc.odbc.JdbcOdbcDriver"); }
            //this.conexio = DriverManager.getConnection(this.getURL(), this.getLogin(), this.getPassword());
            this.conexio = DriverManager.getConnection(this.getURL());
            //Si ha conectat, ho fica:
            if (conexio != null)
            {
                conectat = true;
                this.setConectat(conectat);
            }
        }
        return conectat;
    }
    
    public boolean desconecta() //throws Exception
    {
        boolean desconectat = false;

        //Si esta conectat, desconecta:
        if (this.getConectat())
        {
            try
            {
                this.conexio.close();
                desconectat = true;
                this.setConectat(!desconectat);
            }
            catch (Exception e) { System.out.println("Excepcio: " + e.getMessage()); }
        }
        
        return desconectat;
    }
    
    public ResultSet consulta(String consulta) throws Exception
    {
        ResultSet resultat = null;
        
        if (this.getConectat() && consulta.trim() != "")
        {
            Statement sentencia = this.conexio.createStatement();
            
            resultat = sentencia.executeQuery(consulta);
            
            this.setResultats(resultat);
            
            //Si es tanca, dona error (?):
            //sentencia.close();
        }
        
        return resultat;
    }
    
    public boolean consultaModificacio(String consultaModificacio) throws Exception
    {
        boolean totBe = false;
        
        if (this.getConectat() && consultaModificacio.trim() != "")
        {
            Statement sentencia = this.conexio.createStatement();
            
            int numeroResultats = sentencia.executeUpdate(consultaModificacio);
            
            totBe = true; //No es pot mirar si resultat es null perque mai ho es.

            sentencia.close();
        }
        
        return totBe;
    }
    
    public void mostrarResultat(ResultSet resultat) throws Exception
    {
        //if (resultat == null) { throw new Exception("El resultat es null!!!"); }
        if (resultat == null) { System.out.println("El resultat es null!!!"); }
        
        ResultSetMetaData metaData = resultat.getMetaData();
        String columna;
        
        for (int x = 0; x < metaData.getColumnCount(); x++)
        {
            columna = metaData.getColumnName(x);
            
            System.out.println(columna + "\t");
            
            //metaData.getColumnType(x);
        }
        
        System.out.println("");
        
        while (resultat.next())
        {
            for (int x = 0; x < metaData.getColumnCount(); x++)
            {
                System.out.println(resultat.getString(x) + "\t");
            }
            System.out.println("");
        }
    }
    
    public boolean importa(String fitxer) throws Exception //NOTA: admiteix que no tingui l'extensio .sql
    {
        System.out.println("Accedint a " + fitxer + "...");
        
        //NOTA: ha d'evitar lectures brutes!!!
        
        boolean totBe = true;
        
        //Si el fitxer existeix:
        if (1 == 1)
        {
            //Si es pot obrir i llegir:
            if (1 == 1)
            {
                //Guarda el autocommit actual:
                boolean autoComitBackup = this.getAutoComit();
                
                //Es desactiva el autocommit:
                this.setAutoComit(false);
                
                //Llegeix el fitxer i guarda les sentencies (per lots):
                BufferedReader br = null;
                String[] linies = new String[Byte.MAX_VALUE];
                byte numLinies = 0;
                try
                {
                    System.out.println("--- Llegint arxiu...");
                    br = new BufferedReader(new FileReader(fitxer));
                    linies[0] = "";
                    String linia;
                    byte x = 0;
                    while((linia = br.readLine()) != null)
                    {
                        //Sempre que la linia no estigui buida o sigui un comentari:
                        if (!linia.trim().equals("") && !linia.trim().substring(0, 1).equals("#"))
                        {
                            //Si es detecta un caracter de final de sentencia:
                            if (linia.indexOf(";") != -1)
                            {
                                //Des de la linia fins al final de sentencia, s'afegeix en la linia actual:
                                linies[x] += linia.trim().substring(0, linia.indexOf(";") + 1);
                                System.out.println("Linia #" + x + ": " + linies[x]);
                                
                                //Es guarda en la seguent linia la resta (si hi ha alguna cosa):
                                linies[++x] = linia.trim().substring(linia.indexOf(";") + 1);
                            }
                            //...si no, continua guardant en la linia actual:
                            else { linies[x] += linia; }
                            
                            //Guarda les linies en un vector de strings:
                            //System.out.println("Linia #" + x + ": " + linia);
                            //linies[x++] = linia;
                        }
                    }
                    numLinies = x;
                    System.out.println("--- L'arxiu ha estat llegit.");
                }
                catch (Exception e)
                {
                    System.out.println(e.getMessage());
                    System.out.println("L'arxiu no es pot llegir.");
                    totBe = false;
                }
                finally
                {
                    try
                    {
                        //Si esta obert, tanca l'arxiu:
                        if (br != null) { br.close(); System.out.println("L'arxiu s'ha tancat."); }
                    }
                    catch (Exception e)
                    {
                        System.out.println(e.getMessage());
                        System.out.println("L'arxiu no s'ha pogut tancar.");
                        totBe = false; //Tampoc es tan important que no es pugui tancar, pero bueno.
                    }
                }
                
                //Si tot ha anat be, executa les sentencies per lots:
                if (totBe && linies != null) //Mai sera null pero si no el NetBeans es queixava.
                {
                    System.out.println("--- Executant linies...");
                    //Executa les sentencies per lots:
                    //for (String setencia in linies)
                    Statement stmt = this.conexio.createStatement();
                    for (byte x = 0; x < numLinies; x++)
                    {
                        if (!linies[x].trim().equals(""))
                        {
                            stmt.addBatch(linies[x]);
                        }
                    }
                    try
                    {
                        int[] updateCounts = stmt.executeBatch();
                    }
                    catch (Exception e)
                    {
                        System.out.println("Error a l'executar les linies.");
                        System.out.println(e.getMessage());
                        totBe = false;
                    }
                    
                    System.out.println("--- Fi de l'execucio de les linies.");
                    
                    //Si s'ha produit algun error, es desfa tot:
                    if (!totBe) { this.rollback(); System.out.println("Fem rollback."); }
                    //...pero si no, es realitzen els canvis:
                    else { this.commit(); System.out.println("Fem commit."); }
                    
                } else { totBe = false; System.out.println("No es poden executar les linies."); }
                
                //Torna el autocommit tal com estava:
                this.setAutoComit(autoComitBackup);
            }
            //...si no, dona error:
            else { totBe = false; System.out.println("L'arxiu no es pot obrir."); }
        }
        //...si no, dona error:
        else { totBe = false; System.out.println("L'arxiu no existeix."); }
        
        if (totBe) { System.out.println("L'operacio ha resultat satisfactoria."); }
        else { System.out.println("L'operacio ha resultat erronea."); }
        
        return totBe;
    }
}
