package logica;

import dades.BD;
import java.sql.*;

public class LlibreManegador
{
    public static BD BD;
    
    protected static final String hostname = "127.0.0.1";
    protected static final int port = 3306;
    protected static final String DBName = "bdllibres";

    protected static final String login = "root";
    protected static final String password = "";
    
    public static void conectaBD() throws Exception
    {
        LlibreManegador.BD = new BD("MYSQL", LlibreManegador.hostname, LlibreManegador.port, LlibreManegador.DBName, LlibreManegador.login, LlibreManegador.password);
    }
    
    public static void desconectaBD()
    {
        LlibreManegador.BD.desconecta();
    }
    
    public static Llibre creaLlibre(String ISBN, String titol, String autor, String editorial, float preu)
    {
        return new Llibre(ISBN, titol, autor, editorial, preu);
    }
    
    public static Llibre agafaLlibre(String ISBN)
    {
        Llibre llibre = null;
        if (LlibreManegador.BD != null && LlibreManegador.BD.getConectat())
        {
            try
            {
                llibre = new Llibre(ISBN, LlibreManegador.BD);
                if (!llibre.existeixDadesISBN(ISBN, LlibreManegador.BD)) { llibre = null; }
            } catch (Exception e) { System.out.println("Excepcio: " + e.getMessage()); }
        }
        return llibre;
    }
    
    public static boolean insereixLlibre(Llibre llibre) throws Exception
    {
        if (LlibreManegador.BD != null && LlibreManegador.BD.getConectat())
        {
            boolean totBe = llibre.inserirDades(LlibreManegador.BD);
            return totBe;
        } else { return false; }
    }

    public static boolean modificaLlibre(Llibre llibre, String ISBN, String titol, String autor, String editorial, float preu) throws Exception
    {
        if (ISBN == null || ISBN.trim() == "") { ISBN = "cap"; }
        if (titol == null || titol.trim() == "") { titol = "cap"; }
        if (autor == null || autor.trim() == "") { autor = "cap"; }
        if (editorial == null || editorial.trim() == "") { editorial = "cap"; }
        
        if (LlibreManegador.BD != null && LlibreManegador.BD.getConectat())
        {
            //llibre.setISBN(ISBN);
            llibre.setTitol(titol);
            llibre.setAutor(autor);
            llibre.setEditorial(editorial);
            llibre.setPreu(preu);
            return llibre.modificarDades(LlibreManegador.BD);
        } else { return false; }
    }
    
    public static boolean esborraLlibre(Llibre llibre) throws Exception
    {
        if (LlibreManegador.BD != null && LlibreManegador.BD.getConectat())
        {
            return llibre.esborraDades(LlibreManegador.BD);
        } else { return false; }
    }
}