package examen;

import java.util.Stack;

public class PoolBD
{
    protected Stack<BD> connexions = new Stack<BD>();
    protected final int MAX_CONNEXIONS = 10;
    protected int connexionsServides = 0;
    
    //Nota: no es convenient ficar les dades com password, etc. aqui, pero es per fer-lo mes senzill.
    protected String tipus = "MYSQL";
    protected String hostname = "127.0.0.1";
    protected int port = 3306;
    protected String dbname = "examen";
    protected String login = "root";
    protected String password = "";
   
    public PoolBD()
    {
    }

    public PoolBD(String tipus, String hostname, int port, String dbname, String login, String password)
    {
        this.setTipus(tipus);
        this.setHostname(hostname);
        this.setPort(port);
        this.setDbname(dbname);
        this.setLogin(login);
        this.setPassword(password);
    }
    
    public synchronized BD extreureBD() throws Exception
    {
        BD bd = null;
        
        //Si hi han connexions per servir, serveix una:
        if (!this.connexions.isEmpty())
        {
            bd = this.connexions.pop();
        }
        //...si no, si es poden servir mes serveix una nova (aixo es quan la pila encara no ha estat plena mai):
        else
        {
            if (this.connexionsServides < this.MAX_CONNEXIONS)
            {
                bd = new BD(this.getTipus(), this.getHostname(), this.getPort(), this.getDbname(), this.getLogin(), this.getPassword());
            }
        }
        
        if (bd != null) { this.connexionsServides++; }
        
        return bd;
    }
     
    public synchronized void alliberarConnexi(BD objecteBD)
    {
        if (objecteBD != null)
        {
            this.connexions.push(objecteBD); //No desconnectem i aixi estalviem tenir que connectar.
        }
    }

    public String getTipus()
    {
        return tipus;
    }

    public void setTipus(String tipus)
    {
        this.tipus = tipus;
    }

    public String getHostname()
    {
        return hostname;
    }

    public void setHostname(String hostname)
    {
        this.hostname = hostname;
    }

    public int getPort()
    {
        return port;
    }

    public void setPort(int port)
    {
        this.port = port;
    }

    public String getDbname()
    {
        return dbname;
    }

    public void setDbname(String dbname)
    {
        this.dbname = dbname;
    }

    public String getLogin()
    {
        return login;
    }

    public void setLogin(String login)
    {
        this.login = login;
    }

    public String getPassword()
    {
        return password;
    }

    public void setPassword(String password)
    {
        this.password = password;
    }
}
