package examen;

import java.io.*;
import java.net.*;
import javax.crypto.NullCipher;

import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;

public class ServletCalculIMC extends HttpServlet
{
    public BD bd = null;
    public PoolBD poolDB = null;
    public PrintWriter out = null;
    
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException
    {
        response.setContentType("text/html;charset=UTF-8");
        
        this.out = response.getWriter();
        
        //Agafa una base de dades amb una connexio:
        try
        {
            this.bd = this.poolDB.extreureBD();
        
            //Si no s'ha pogut agafar una connexio, ho notifica i surt:
            if (this.bd == null || !this.bd.getConectat()) { response.sendRedirect("ocupat.html"); return; }
        
            //Si no existeix un objecte Usuari de sessio, surt cap el login:
            HttpSession sessio = request.getSession();
            Usuari usuari = (Usuari) sessio.getAttribute("usuari");
            if (usuari == null) { response.sendRedirect("login.html?missatge=Identifiacio+obligatoria"); }

            //Recull les dades enviades i/o necessaries:
            String login = null;
            float pes = 0;
            float altura = 0;
            
            try
            {
                login = usuari.getUsuari();
                if (login != null) { login = login.trim(); }
                else { login = ""; }
                pes = Float.parseFloat(request.getParameter("pes"));
                altura = Float.parseFloat(request.getParameter("altura"));
            }
            catch (Exception e) { this.mostraError("Alguna dada enviada es incorrecta"); this.log("Excepcio: " + e.getMessage()); return; }
        
            //Si alguna dada enviada es incorrecta o falta, torna cap a ServletEntrada:
            if (login == null || login == "" || pes <= 0 || altura <= 0) { this.mostraError("Alguna dada enviada es incorrecta"); return; }
        
            //Crea l'objecte Salud:
            Salud salud = new Salud(login, pes, altura, bd);
        
            //Si tot es correcte, insereix les dades a la base de dades:
            boolean ficades = false;
            if (salud.dadesCorrectes())
            {
                ficades = salud.insereixRegistre();
            } else { ficades = false; }
        
            //Si les dades s'han ficat be, ho notifica:
            if (ficades) { this.mostraTotBe(salud); }
            //...i si no, tambe:
            else { this.mostraError("Alguna dada enviada es incorrecta"); }
        }
        catch (Exception e) { this.log("Excepcio: " + e.getMessage()); } //No redirigim.
        finally
        {
            if (this.bd != null) { this.poolDB.alliberarConnexi(this.bd); }
            out.close();
        }
    }
    
    public void mostraError(String missatge)
    {
        this.out.println(missatge);
        this.out.println(this.getLinkEnrera());
    }
    

    public void mostraTotBe(Salud salud)
    {
        String missatge = salud.getMissatgeImc();
        this.out.println(missatge + "<br>");
        this.out.println("El teu IMC es de: " + salud.getImc()); //Surten mols decimals, pero aixi tambe es mes precis.
        this.out.println(this.getLinkEnrera());
    }
    
    public String getLinkEnrera()
    {
        return "<br><br><a href=\"ServletEntrada\">Torna</a>";
    }
    
    public void init() throws ServletException
    {
        super.init();
        
        ServletContext app = this.getServletContext();
        
        //Recull l'objecte d'application:
        Object elmeupool = app.getAttribute("elmeupool");
        
        //Si no existeix l'objecte d'application, el crea:
        if (elmeupool == null)
        {
            elmeupool = new PoolBD(); //Lo normal seria utilizar password, etc. des d'aqui, pero ja ho te ficat l'objecte PoolBD (es per fer un exemple, no tinc molt en compte la seguretat).
            app.setAttribute("elmeupool", elmeupool);
        }
        //Fica a la propietat:
        this.poolDB = (PoolBD) elmeupool;
    }
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
