package accions;

import javax.servlet.http.*;
import org.apache.struts.action.*;
import beans.*;
import java.sql.*;

import beans.LlibreBean;

import java.util.*;

public class FormulariAfegirAction extends Action
{
    private final static String SUCCESS = "success";
    
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception
    {
        boolean totBe = true;
        
        FormulariAfegirBean formulari = (FormulariAfegirBean) form;
        
        boolean afegir = (request.getParameter("Afegir") != null);
        
        //Si s'ha escollit afegir, afegeix el nou llibre:
        if (afegir)
        {
            //Si el id del llibre no es 0 (cap selleccionat):
            String idLlibre = formulari.getIdLlibre();
            if (!idLlibre.equals("0"))
            {
                //Afegeix el llibre en la sessio:
                String ISBN = formulari.getIdLlibre();
                
                //LlibreBean llibreEscollit = ((ArrayList) request.getSession().getAttribute("matriuLlibres")).get(ISBN);
                ArrayList llibresLlistat = (ArrayList) request.getSession().getAttribute("matriuLlibres");
                
                LlibreBean llibreEscollit  = null;
                for (int x = 0; x < llibresLlistat.size(); x++)
                {
                    String ISBNbucle = ((LlibreBean) llibresLlistat.get(x)).getIsbn();
                    if (ISBNbucle == ISBN)
                    {
                        llibreEscollit = (LlibreBean) llibresLlistat.get(x);
                        break;
                    }
                }
                
                if (llibreEscollit != null)
                {
                    ArrayList arrayLlibresAfegits = (ArrayList) request.getSession().getAttribute("matriuLlibresAfegits");
                    arrayLlibresAfegits.add(llibreEscollit);
                }
            }
        }
        //...si no, s'ha selleccionat una categoria, aixi que la carrega:
        else
        {
            String idCategoria = formulari.getIdCategoria();
            
            javax.sql.DataSource dataSource = null;
            java.sql.Connection myConnection = null;
            try
            {
                dataSource = this.getDataSource(request, "primerDataSource");
                myConnection = dataSource.getConnection();
                Statement st = myConnection.createStatement();

                ArrayList arrayLlibres = (ArrayList) request.getSession().getAttribute("matriuLlibres");
                ResultSet rs = st.executeQuery("SELECT * FROM llibres AS a JOIN llibres_categoria AS b JOIN categories AS c ON a.ISBN = b.ISBN AND b.id_categoria = c.id WHERE b.id_categoria = " + idCategoria);
                while (rs.next())
                {
                    arrayLlibres.add(new LlibreBean(rs.getString("ISBN"), rs.getString("titol"), rs.getString("autor"), rs.getString("editorial"), rs.getInt("quantitat"), rs.getString("nom"), rs.getFloat("preu")));
                }
                
                request.getSession().setAttribute("matriuLlibres", arrayLlibres); //Fiquem la matriu a l'"aplicacio".
            }
            catch (Exception ex)
            {
                getServlet().log("Connection.process", ex);
            }
            finally
            {
                try
                {
                    if (myConnection != null)
                    {
                        myConnection.close();
                    }
                    else { totBe = false; }
                }
                catch (Exception ex)
                {
                    getServlet().log("Connection.close ", ex);
                }
            }
        }
        
        ActionForward redireccio = totBe ? mapping.findForward("ok") : mapping.findForward("error");
        
        return redireccio;
    }
}