package accions;

import javax.servlet.http.*;
import org.apache.struts.action.*;
import beans.*;
import java.sql.*;

import beans.LlibreBean;

import java.util.*;

public class FormulariAfegirAction extends Action
{
    private final static String SUCCESS = "success";
    
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception
    {
        if (request.getSession().getAttribute("matriuLlibresAfegits") == null) { request.getSession().setAttribute("matriuLlibresAfegits", new ArrayList()); }
        ArrayList arrayLlibresAfegits = (ArrayList) request.getSession().getAttribute("matriuLlibresAfegits");
        
        boolean totBe = true;
        
        FormulariAfegirBean formulari = (FormulariAfegirBean) form;
        
        boolean afegir = (request.getParameter("boto") != null && request.getParameter("boto").equals("Afegeix"));
        
        //Si s'ha escollit afegir, afegeix el nou llibre:
        if (afegir)
        {
            //Si el id del llibre no es 0 (cap selleccionat):
            String idLlibre = formulari.getIdLlibre();
            if (!idLlibre.equals("0"))
            {
                String ISBN = formulari.getIdLlibre();
                int quantitat;
                try
                {
                    quantitat = Integer.parseInt(formulari.getQuantitat());
                }
                catch (Exception e) { quantitat = 1; }

                //Busca el llibre que es vol afegir, del llistat que es podia selleccionar:
                ArrayList llibresLlistat = (ArrayList) request.getSession().getAttribute("matriuLlibres");

                LlibreBean llibreEscollit  = null;
                for (int x = 0; x < llibresLlistat.size(); x++)
                {
                    String ISBNbucle = ((LlibreBean) llibresLlistat.get(x)).getIsbn();
                    if (ISBNbucle.equals(ISBN))
                    {
                        llibreEscollit = (LlibreBean) llibresLlistat.get(x);
                        llibreEscollit = new LlibreBean(llibreEscollit.getIsbn(), llibreEscollit.getTitol(), llibreEscollit.getAutor(), llibreEscollit.getEditorial(), quantitat, llibreEscollit.getCategoria(), llibreEscollit.getPreu());
                        break;
                    }
                }

                //Busca el llibre que es vol afegir, per si ja estava afegit:
                LlibreBean llibreExistent = null;
                if (request.getSession().getAttribute("matriuLlibresAfegits") != null)
                {
                    ArrayList llibresAfegitsLlistat = (ArrayList) request.getSession().getAttribute("matriuLlibresAfegits");
                    for (int x = 0; x < llibresAfegitsLlistat.size(); x++)
                    {
                        String ISBNbucle = ((LlibreBean) llibresAfegitsLlistat.get(x)).getIsbn();
                        if (ISBNbucle.equals(ISBN))
                        {
                            llibreExistent = (LlibreBean) llibresAfegitsLlistat.get(x);
                            break;
                        }
                    }
                }

                //if (request.getSession().getAttribute("matriuLlibresAfegits") == null) { request.getSession().setAttribute("matriuLlibresAfegits", new ArrayList()); }
                //ArrayList arrayLlibresAfegits = (ArrayList) request.getSession().getAttribute("matriuLlibresAfegits");
                
                //Si ja existeix, incrementa la quantitat:
                if (llibreExistent != null)
                {
                    //llibreEscollit.setQuantitat(llibreEscollit.getQuantitat() + quantitat);
                    //((LlibreBean)((ArrayList)request.getSession().getAttribute("matriuLlibresAfegits")).get(x - 1)).setQuantitat();
                    llibreExistent.setQuantitat(llibreExistent.getQuantitat() + quantitat);
                }
                //...si no, l'afegeix (si s'ha escollit un):
                else if (llibreEscollit != null)
                {
                    arrayLlibresAfegits.add(llibreEscollit);
                }
                
                //Actualitza el llistat de text per mostrar:
                //formulari.setLlibresAfegits(arrayLlibresAfegits);
            }
        }
        //...si no, s'ha selleccionat una categoria, aixi que la carrega:
        else
        {
            
            int idCategoria = 0;
            try
            {
                idCategoria = Integer.parseInt(formulari.getIdCategoria());
            }
            catch (Exception ex) { idCategoria = 0; }
            
            if (idCategoria > 0) //Si es 0 sera la frase "Tria una categoria", i si es menor es una cosa rara.
            {
                javax.sql.DataSource dataSource = null;
                java.sql.Connection myConnection = null;
                try
                {
                    dataSource = this.getDataSource(request, "primerDataSource");
                    myConnection = dataSource.getConnection();
                    Statement st = myConnection.createStatement();

                    ArrayList arrayLlibres = (ArrayList) request.getSession().getAttribute("matriuLlibres");
                    ResultSet rs = st.executeQuery("SELECT DISTINCT * FROM llibres AS a JOIN llibres_categoria AS b JOIN categories AS c ON a.ISBN = b.ISBN AND b.id_categoria = c.id WHERE b.id_categoria = " + idCategoria);

                    arrayLlibres.clear();
                    while (rs.next())
                    {
                        arrayLlibres.add(new LlibreBean(rs.getString("ISBN"), rs.getString("titol"), rs.getString("autor"), rs.getString("editorial"), 0, rs.getString("nom"), rs.getFloat("preu")));
                    }

                    request.getSession().setAttribute("matriuLlibres", arrayLlibres); //Fiquem la matriu a l'"aplicacio".
                }
                catch (Exception ex)
                {
                    getServlet().log("Connection.process", ex);
                }
                finally
                {
                    try
                    {
                        if (myConnection != null)
                        {
                            myConnection.close();
                        }
                        else { totBe = false; }
                    }
                    catch (Exception ex)
                    {
                        getServlet().log("Connection.close ", ex);
                    }
                }
            }
            
            //ArrayList arrayLlibresAfegits = (ArrayList) request.getSession().getAttribute("matriuLlibresAfegits");
            
            //formulari.setLlibresAfegits(arrayLlibresAfegits);
        }
        
        //Actualitza el llistat de text per mostrar:
        formulari.setLlibresAfegits(arrayLlibresAfegits);
        
        ActionForward redireccio = totBe ? mapping.findForward("ok") : mapping.findForward("error");
        
        return redireccio;
    }
}