package accions;

import javax.servlet.http.*;
import org.apache.struts.action.*;
import beans.*;
import java.sql.*;

import java.util.*;

import classes.*;

public class FormulariAction extends Action
{
    private final static String SUCCESS = "success";
    
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception
    {
        boolean totBe = true;

        FormulariBean formulari = (FormulariBean) form;
        
        //Fa la accio segons el boto:
        String boto = request.getParameter("boto");
        if (boto != null)
        {
            //Si s'ha escollit [>]:
            if (boto.equals("&gt;") || boto.equals(">"))
            {
                int usuariEscollit = formulari.getIdUsuari();
                this.seleccionarUsuari(request, usuariEscollit);
            }
            //...pero si s'ha escollit [<]:
            else if (boto.equals("&lt;") || boto.equals("<"))
            {
                int usuariEscollit = formulari.getIdUsuariSeleccionat();
                this.deseleccionarUsuari(request, usuariEscollit);
            }
            //...pero si s'ha escollit [>>]:
            else if (boto.equals("&gt;&gt;") || boto.equals(">>"))
            {
                this.seleccionarUsuaris(request);
            }
            //...pero si s'ha escollit [<<]:
            else if (boto.equals("&lt;&lt;") || boto.equals("<<"))
            {
                this.deseleccionarUsuaris(request);
            }
            //...pero si se ha escollit [Guarda]:
            else if (boto.equals("Guarda"))
            {
                totBe = this.guardaCanvis(request);
                if (totBe) { formulari.setMissatges("Dades guardades correctament"); }
                else { formulari.setErrors("Les dades no s'han pogut guardar :("); }
            }
            //...pero si no (cosa rara):
            else
            {
                formulari.setMissatges("Accio desconeguda :( (<b>" + boto + "</b>)");
            }
        }
        
        ActionForward redireccio = totBe ? mapping.findForward("ok") : mapping.findForward("error");
        
        return redireccio;
    }
    
    //Busca un usuari en un ArrayList, el treu i retorna un igual:
    protected Usuari popUsuari(int idUsuari, ArrayList usuaris)
    {
        Usuari usuariEscollit = null;
                
        Usuari usuariLoop;
        for (int x = 0; x < usuaris.size(); x++)
        {
            usuariLoop = (Usuari) usuaris.get(x);
            if (usuariLoop.getId() == idUsuari)
            {
                usuariEscollit = new Usuari(usuariLoop.getId(), usuariLoop.getNom());
                usuaris.remove((Object) usuariLoop); //Crec que no fa falta el casting a Object un altre cop, pero com funciona per referencies tinc por a perdre la original ja que he fet un casting a Usuari abans.
                break;
            }
        }
        return usuariEscollit;
    }
    
    //Bolca el contigut d'un ArrayList en un altre (esborrant la origen):
    protected void bolcaUsuaris(ArrayList usuarisOrigen, ArrayList usuarisDesti)
    {
        //Fica tots els usuaris origen amb els que hi han -o poden haver- en desti:
        usuarisDesti.addAll(usuarisOrigen);

        //Esborra tots els usuaris de l'origen:
        usuarisOrigen.clear();
    }
    
    //Selecciona un usuari:
    protected void seleccionarUsuari(HttpServletRequest request, int idUsuari)
    {
        ArrayList usuaris = (ArrayList) request.getSession().getAttribute("usuaris");
        Usuari usuariEscollit = null;
        
        if (usuaris != null)
        {
            //Busca l'usuari escollit i l'esborra dels no seleccionats:
            usuariEscollit = this.popUsuari(idUsuari, usuaris);
           
            //Si s'ha trobat l'usuari escollit:
            if (usuariEscollit != null)
            {
                //L'afegeix als usuaris seleccionats:
                ArrayList usuarisSeleccionats = (ArrayList) request.getSession().getAttribute("usuarisSeleccionats");
                usuarisSeleccionats.add(usuariEscollit);
            }
        }
    }
    
    //Deselecciona un usuari:
    protected void deseleccionarUsuari(HttpServletRequest request, int idUsuari)
    {
        ArrayList usuarisSeleccionats = (ArrayList) request.getSession().getAttribute("usuarisSeleccionats");
        Usuari usuariEscollit = null;
        
        //Busca l'usuari escollit i l'esborra dels seleccionats:
        if (usuarisSeleccionats != null)
        {
            //Busca l'usuari escollit i l'esborra dels no seleccionats:
            usuariEscollit = this.popUsuari(idUsuari, usuarisSeleccionats);
            
            //Si s'ha trobat l'usuari escollit:
            if (usuariEscollit != null)
            {
                //L'afegeix als usuaris no seleccionats:
                ArrayList usuaris = (ArrayList) request.getSession().getAttribute("usuaris");
                usuaris.add(usuariEscollit);
            }
        }
    }
    
    //Selecciona tots els usuaris:
    protected void seleccionarUsuaris(HttpServletRequest request)
    {
        ArrayList usuaris = (ArrayList) request.getSession().getAttribute("usuaris");
        ArrayList usuarisSeleccionats = (ArrayList) request.getSession().getAttribute("usuarisSeleccionats");
        if (usuaris != null)
        {
            //Fica els usuaris com seleccionats:
            this.bolcaUsuaris(usuaris, usuarisSeleccionats);
        }
    }

    //Deselecciona tots els usuaris:
    protected void deseleccionarUsuaris(HttpServletRequest request)
    {
        ArrayList usuaris = (ArrayList) request.getSession().getAttribute("usuaris");
        ArrayList usuarisSeleccionats = (ArrayList) request.getSession().getAttribute("usuarisSeleccionats");
        if (usuaris != null)
        {
            //Fica els usuaris seleccionats com no seleccionats:
            this.bolcaUsuaris(usuarisSeleccionats, usuaris);
        }
    }
    
    //Guarda els canvis:
    protected boolean guardaCanvis(HttpServletRequest request) throws Exception
    {
        ArrayList usuarisSeleccionats = (ArrayList) request.getSession().getAttribute("usuarisSeleccionats");
        int filesAfectades = 0;

        javax.sql.DataSource dataSource = null;
        java.sql.Connection myConnection = null;
        
        try
        {
            //Agafa una connexio a la base de dades:
            dataSource = this.getDataSource(request, "primerDataSource");
            myConnection = dataSource.getConnection();

            //Si s'ha pogut agafar una connexio a la base de dades:
            if (myConnection != null)
            {
                Statement st = myConnection.createStatement();

                //Esborra tots els usuaris seleccionats fins ara:
                st.executeUpdate("TRUNCATE TABLE deguardia");

                //Afegeix els usuaris seleccionats:
                Usuari usuariLoop;
                for (int x = 0; x < usuarisSeleccionats.size(); x++)
                {
                    usuariLoop = (Usuari) usuarisSeleccionats.get(x);
                    filesAfectades += st.executeUpdate("INSERT INTO deguardia (idEmpleat) VALUES ('" + usuariLoop.getId() + "')");
                }
            }
        }
        catch (Exception e)
        {
            throw e; //Torna a llenar l'excepcio, per a que el Java s'encarregui.
        }
        finally
        {
            //Si tenim ocupada una connexio encara, l'alliberem:
            if (myConnection != null) { myConnection.close(); }
        }
        
        //Retorna true si els usuaris afegits son exactament els seleccionats (ni mes ni menys):
        return (filesAfectades == usuarisSeleccionats.size());
    }
}