package servlets;

import java.io.*;
import java.net.*;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

import javax.servlet.*;
import javax.servlet.http.*;

import java.util.*;

import java.sql.*;
import javax.sql.*;

import beans.*;

import classes.*;

public class inici extends HttpServlet
{
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException
    {
        DataSource dataSource = null;
        Connection myConnection = null;
        try
        {
            //Agafa una conexio a la base de dades:
            Context env = (Context) new InitialContext().lookup("java:comp/env");
            dataSource = (DataSource) env.lookup("jdbc/exdai2"); //dataSource = this.getDataSource(request, "primerDataSource");
            myConnection = dataSource.getConnection();
        
            //Carrega els usuaris no seleccionats a la sessio:
            this.carregaUsuarisSessio(myConnection, request);

            //Carrega els usuaris seleccionats a la sessio:
            this.carregaUsuarisSeleccionatsSessio(myConnection, request);
            
            //Redirigeix cap a la pagina principal:
            request.getRequestDispatcher("/index.jsp").forward(request, response);
        }
        catch (Exception ex)
        {
            log("Connection.process", ex);
        }
        finally
        {
            //Allibera la connexio a la base de dades:
            try
            {
                if (myConnection != null) { myConnection.close(); }
            }
            catch (Exception ex)
            {
                log("Connection.close ", ex);
                //((FormulariBean) request.getSession().getAttribute("FormulariBean")).setMissatges(ex.getMessage());
            }
        }
    }
    
    //Carrega els usuaris no seleccionats de la base de dades a la sessio:
    protected void carregaUsuarisSessio(Connection connexio, HttpServletRequest request) throws Exception
    {
        Statement st = connexio.createStatement();
        ResultSet rs = st.executeQuery("SELECT * FROM empleat WHERE id NOT IN (SELECT * FROM deguardia)");
        
        this.carregaUsuarisResultSetSessio(request, rs, "usuaris");
    }

    //Carrega els usuaris seleccionats de la base de dades a la sessio:
    protected void carregaUsuarisSeleccionatsSessio(Connection connexio, HttpServletRequest request) throws Exception
    {
        Statement st = connexio.createStatement();
        ResultSet rs = st.executeQuery("SELECT * FROM empleat WHERE id IN (SELECT * FROM deguardia)");
        
        this.carregaUsuarisResultSetSessio(request, rs, "usuarisSeleccionats");
    }
    
    //Carrega els usuaris d'un ResultSet a la sessio:
    protected void carregaUsuarisResultSetSessio(HttpServletRequest request, ResultSet rs, String nomVariableSessio) throws Exception
    {
        ArrayList usuaris = new ArrayList();
        
        while (rs.next())
        {
            usuaris.add(new Usuari(rs.getInt("id"), rs.getString("nom")));
        }
        
        request.getSession().setAttribute(nomVariableSessio, usuaris);
    }
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
