package servlets;

import java.io.*;
import java.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import javax.sql.*;
import javax.naming.*;
import java.sql.*;

import java.util.*;

import beans.Categoria;

public class ServletInicialWelcome extends HttpServlet
{
    DataSource elMeuDS = null;
    
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException
    {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        
        //Solament entra el primer cop:
        if (this.getServletContext().getAttribute("matriu") == null)
        {

            //Seria millor fer-lo en el init, pero es per fer un exemple rapid:
            Connection con = null;
            ArrayList array = new ArrayList();
            try { 
                    Context contextoInicial = new InitialContext(); 
                    Context contexto = (Context) contextoInicial.lookup("java:comp/env"); 
                    elMeuDS = (DataSource) contexto.lookup( "jdbc/ConnexioBDLlibres");
                    con = elMeuDS.getConnection();
                    Statement st = con.createStatement();
                    ResultSet rs = st.executeQuery("SELECT * FROM categoria");
                    while (rs.next())
                    {
                        array.add(new Categoria(rs.getInt("id"), rs.getString("categoria")));
                    }
            } 
            catch(NameNotFoundException e) { 
                    // el que sigui
            }
            catch(Exception e) { 
                    // el que sigui
            }
            finally
            {
                try
                {
                    if (con != null)
                    {
                        con.close();
                    }
                }
                catch (SQLException ex)
                {
                    //el que sigui.
                }
            }

            //HttpSession sessio = request.getSession();
            //sessio.setAttribute("matriu", array);
            //Millo ficar-lo en un objecte aplicacio:
            this.getServletContext().setAttribute("matriu", array);        
        }
        
        //Redirigim cap a la pagina welcomeStruts.jsp:
        RequestDispatcher rD = request.getRequestDispatcher("/welcomeStruts.jsp");
        rD.forward(request, response);
        
        out.close();
    }
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
