package finalstrimestre;

import java.util.*;
import java.io.*;

public class PilaEnllaos //No se si donara problemes el utilitzar "".
{
    private Stack<Link> pila = new Stack<Link>();
    
    public PilaEnllaos()
    {
    }

    public PilaEnllaos(Link primerLink)
    {
        this.afegirLink(primerLink);
    }

    public PilaEnllaos(String text, String URL) throws MevaExcepcio
    {
        Link primerLink = new Link(text, URL);
        this.afegirLink(primerLink);
    }
    
    public PilaEnllaos(PilaEnllaos altraPila)
    {
        this.pila = (Stack) altraPila.getPila().clone();
        //this.getPila() = (Stack) altraPila.getPila().clone(); //No va!
    }

    public Stack<Link> getPila()
    {
        return this.pila;
    }
    
    public void afegirLink(Link link) //Afegeir un element a l'ultima posicio.
    {
        pila.push(link);
    }

    public void afegirLink(String text, String URL) throws MevaExcepcio //Afegeir un element a l'ultima posicio.
    {
        Link link = new Link(text, URL);
        pila.push(link);
    }
    
    public Link consultaLink() throws EmptyStackException //Consulta l'ultim element de la pila.
    {
        //if (pila.isEmpty()) { return null; }
        return pila.peek(); 
    }
    
    public void eliminaLink() throws EmptyStackException  //Elimina l'ultim element de la pila.
    {
        //if (pila.isEmpty()) { return; }
        pila.pop();
    }
    
    public String escriurePila()
    {
        String cadena = "";
        for (Link link : this.getPila())
        {
            cadena += link.getText() + " " + link.getURL() + "\n";
        }
        return cadena;
    }
    
    public String escriurePilaHTML()
    {
        String cadena = "";
        for (Link link : this.getPila())
        {
            cadena += escriureLinkHTML(link) + "<br>\n";
        }
        return cadena;
    }
    
    private String escriureLinkHTML(Link link)
    {
        return "<a href=\"" + link.getURL() + "\">" + link.getText() + "</a>";
    }

    public String creaHTML() throws Exception
    {
        String nom = "links";
        String extensio = "htm";
        return this.creaHTML(nom, extensio);
    }
    
    public String creaHTML(String nom) throws Exception
    {
        String extensio = "htm";
        return this.creaHTML(nom, extensio);
    }
    
    public String creaHTML(String nom, String extensio) throws Exception
    {
        extensio.replace(".", "");
        String nomArxiu = nom + "." + extensio;
        
        FileWriter fw = new FileWriter(nomArxiu);
        BufferedWriter bw = new BufferedWriter(fw);
        PrintWriter salida = new PrintWriter(bw);
        
        salida.println( "<html>" +
                            "<head>" +
                                "<title>Titol (podria ser un parametre de la funcio)</title>" +
                            "</head>" +
                            "<body bgcolor=\"#ffaadd\">" +
                            "<h1>Links</h1>" +
                            this.escriurePilaHTML() +
                            "</body>" +
                        "</html>");
        
        salida.close();
        
        return nomArxiu;
    }

    public void creaObreHTML() throws Exception
    {
        //String nomArxiu = this.creaHTML();
        //this.executa(nomArxiu);
        this.executa(this.creaHTML());
    }

    public void creaObreHTML(String nom) throws Exception
    {
        this.executa(this.creaHTML(nom));
    }

    public void creaObreHTML(String nom, String extensio) throws Exception
    {
        this.executa(this.creaHTML(nom, extensio));
    }
    
    public void executa(String nomArxiu) throws Exception
    {
        Runtime sistema = Runtime.getRuntime();
        sistema.exec("explorer " + nomArxiu); //iexplore.exe (navegador) no es lo mateix que explorer.exe (explorador de Windows)!
    }
}