/** 
 * 
 * @author Joan Alba Maldonado
 */ 

package logica;

import java.awt.event.KeyListener;

import java.util.Hashtable;

import java.util.Enumeration;

import principal.Main;

import java.awt.event.*;

//FALTA: buscar alguna forma para que al cambiar el foco de la ventana y no soltar una tecla, detecte que se ha soltado. a lo mejor en leerTeclado se peude consultar el estado de la tecla otra vez.

public class Teclado implements KeyListener
{
    static protected Hashtable<Integer, Boolean> teclasPulsadas = new Hashtable<Integer, Boolean>(); //Guarda el estado de las teclas (si estan pulsadas o no).
    static protected long ultimaLecturaTeclado = 0; //Guarda cuando fue la ultima lectura de teclado.
    
    public Teclado()
    {
    }
    
    //Vacia las teclas (pone como si ninguna se ha pulsado):
    static public void vaciarTeclas()
    {
        Teclado.teclasPulsadas.clear();
    }
    
    //Codigo que se ejecuta repetidamente para procesar las teclas pulsadas:
    static synchronized public void leerTeclado(boolean limitadorTiempo)
    {
        if (Main.juego == null) { return; }
        
        //Si se ha enviado utilizar el limitador de tiempo:
        if (limitadorTiempo)
        {
            //Si aun no ha pasado el tiempo necesario, sale:
            long tiempoNecesario = Main.juego.getVelocidadLectorTeclado();
            long tiempoActual = System.currentTimeMillis();
            long tiempoTranscurrido = tiempoActual - Teclado.ultimaLecturaTeclado;
            if (tiempoTranscurrido < tiempoNecesario) { /*System.out.println("Se necesitan " + tiempoNecesario + " y solo han transcurrido " + tiempoTranscurrido + ", asi que sale.");*/ return; }
        }
        
        //Recorre las teclas:
        Enumeration teclas = Teclado.teclasPulsadas.keys();
        
        int tecla;
        boolean pulsada;
        while (teclas.hasMoreElements())
        {
            tecla = (Integer) teclas.nextElement();
            pulsada = Teclado.teclasPulsadas.get(tecla);
            
            //Si la tecla esta pulsada y es valida para el juego, la procesa:
            if (pulsada && Main.juego.teclaEnTeclasTodas(tecla))
            {
                Main.juego.procesarTecla(tecla);
                //break; //Solo deja procesar una tecla.
            }
        }
        
        Teclado.ultimaLecturaTeclado = System.currentTimeMillis();
        //System.out.println("* Lectura de teclado efectuada en: " + Teclado.ultimaLecturaTeclado);
    }
    
    public void keyPressed(KeyEvent e)
    {
        //Si el juego esta activo:
        if (Main.juego != null)
        {
            //Si la tecla es una tecla valida para el juego:
            int tecla = e.getKeyCode();
            if (Main.juego.teclaEnTeclasTodas(tecla))
            {
                //Guarda como que la tecla se ha pulsado:
                Teclado.teclasPulsadas.put(tecla, true);
                
                //Si las teclas son excluyentes, desactiva su contraria:
                int[] teclasIzquierda = Main.juego.getTeclaIzquierda();
                int[] teclasDerecha = Main.juego.getTeclaDerecha();
                int[] teclasArriba = Main.juego.getTeclaArriba();
                int[] teclasAbajo = Main.juego.getTeclaAbajo();
                
                if (Main.juego.teclaEnTeclas(tecla, teclasIzquierda)) //Si se ha apretado izquierda, desactiva derecha.
                {
                    //Desactiva todos los codigos que hagan la misma accion:
                    for (int x = 0; x < teclasDerecha.length; x++)
                    {
                        Teclado.teclasPulsadas.put(teclasDerecha[x], false);
                    }
                }
                else if (Main.juego.teclaEnTeclas(tecla, teclasDerecha)) //Si se ha apretado derecha, desactiva izquierda.
                {
                    //Desactiva todos los codigos que hagan la misma accion:
                    for (int x = 0; x < teclasIzquierda.length; x++)
                    {
                        Teclado.teclasPulsadas.put(teclasIzquierda[x], false);
                    }
                }
                else if (Main.juego.teclaEnTeclas(tecla, teclasArriba)) //Si se ha apretado arriba, desactiva abajo.
                {
                    //Desactiva todos los codigos que hagan la misma accion:
                    for (int x = 0; x < teclasAbajo.length; x++)
                    {
                        Teclado.teclasPulsadas.put(teclasAbajo[x], false);
                    }
                }
                else if (Main.juego.teclaEnTeclas(tecla, teclasAbajo)) //Si se ha apretado abajo, desactiva arriba.
                {
                    //Desactiva todos los codigos que hagan la misma accion:
                    for (int x = 0; x < teclasArriba.length; x++)
                    {
                        Teclado.teclasPulsadas.put(teclasArriba[x], false);
                    }
                }
                
                //Procesa la tecla acabada de pulsar:
                Teclado.leerTeclado(false);
                //Main.juego.procesarTecla(e.getKeyCode());
            }
        }
    }

    public void keyReleased(KeyEvent e)
    {
        //Si el juego esta activo:
        if (Main.juego != null)
        {
            //Si la tecla es una tecla valida para el juego:
            if (Main.juego.teclaEnTeclasTodas(e.getKeyCode()))
            {
                //Guarda como que la tecla se ha dejado de pulsar:
                Teclado.teclasPulsadas.put(e.getKeyCode(), false);
            }
        }
    }

    public void keyTyped(KeyEvent e)
    {
    }
}
