package primera_part;

import java.util.Date;

public class SabataRun extends Producte
{
    protected String marca;
    protected String tipusAmortiguacio = ""; //Per defecte no hi ha.

    public SabataRun(float preu, String codi, String marca, String tipusAmortiguacio) throws Exception
    {
        super(preu, codi);
        this.setMarca(marca);
        this.setTipusAmortiguacio(tipusAmortiguacio);
    }
    
    public SabataRun(float preu, String codi, String descripcio, String marca, String tipusAmortiguacio) throws Exception
    {
        this(preu, codi, marca, tipusAmortiguacio);
        this.setDescripcio(descripcio);
    }

    public SabataRun(float preu, String codi, String descripcio, Date dataCaducitat, String marca, String tipusAmortiguacio) throws Exception
    {
        this(preu, codi, descripcio, marca, tipusAmortiguacio);
        this.setDataCaducitat(dataCaducitat);
    }

    public void setMarca(String marca) throws Exception
    {
        if (marca != null) { this.marca = marca; }
        else { throw new Exception("La marca no pot ser nul"); }
    }
    
    public String getMarca()
    {
        return this.marca;
    }
    
    public void setTipusAmortiguacio(String tipusAmortiguacio) throws Exception
    {
        if (tipusAmortiguacio != null) { this.tipusAmortiguacio = tipusAmortiguacio; }
        else { throw new Exception("El tipus d'amortiguacio no pot ser nul"); }
    }
    
    public String getTipusAmortiguacio()
    {
        return this.tipusAmortiguacio;
    }

    public String toString()
    {
        String cadena;
        
        cadena = " [Marca: " + this.getMarca() + "] [Amortiguacio: " + this.getTipusAmortiguacio() + "]";
        
        return super.toString() + " " + cadena;
    }
}
