package segona_part;

import java.util.Date;

abstract public class AProducte implements IProducte
{
    protected Date dataCaducitat;
    
    public boolean caducat()
    {
        boolean caducat = false;
        
        if (this.getDataCaducitat() != null) //Si es null, no caduca.
        {
            Date dataActual = new Date(); //Aixo es en temps d'execucio "estatic" (la primera vegada que s'executa el programa) o de run?

            if (dataActual.after(this.getDataCaducitat())) { caducat = true; }
        }
        
        return caducat;
    }
    
    public void setDataCaducitat(Date dataCaducitat)
    {
        //Permitim null per si no caduca:
        this.dataCaducitat = dataCaducitat;
    }

    public Date getDataCaducitat()
    {
        return this.dataCaducitat;
    }
}
