package ex1;

import java.util.*;

public class CatalegGeneric<K, V extends LlibreGeneric<K>>
{
    private Hashtable<K, V> Coleccio = new Hashtable<K, V>();
    
    public CatalegGeneric()
    {
        
    }
    
    public CatalegGeneric(V objecte) throws MevaExcepcio
    {
        this.afegirObjecte(objecte);
    }
    
    public CatalegGeneric(CatalegGeneric<K, V> coleccio) throws MevaExcepcio
    {
        this.afegirColeccio(coleccio);
    }
    
    public void afegirObjecte(V objecte) throws MevaExcepcio
    {
        if (objecte == null) { throw new MevaExcepcio("L'objecte apunta a null!"); }
        else if (this.enCataleg(objecte)) { throw new MevaExcepcio("L'objecte ja existeix en la colleccio!"); }
        else //No fa falta el else.
        {
            this.Coleccio.put(objecte.getClau(), objecte);
        }
    }

    public void afegirColeccio(CatalegGeneric<K, V> coleccio) throws MevaExcepcio //Es podria fer amb clone?
    {
        V objecte;
        for (K clau : coleccio.Coleccio.keySet())
        {
            if (!this.enCataleg(clau))
            {
                objecte = coleccio.obtenirObjecte(clau);
                this.afegirObjecte(objecte);
            }
        }
    }
    
    public V obtenirObjecte(K clau)
    {
        //Llibre llibre = null;
       
        return this.Coleccio.get(clau);
        
        //llibre = this.ColeccioLlibres.get(ISBN);
        
        //return llibre;
    }
    
    public boolean enCataleg(K clau)
    {
        boolean trobat = false;
        
        trobat = this.Coleccio.containsKey(clau); //this.ColeccioLlibres.containsValue(ISBN);
        
        return trobat;
    }
    
    public boolean enCataleg(V objecte)
    {
        return enCataleg(objecte.getClau());
    }
    
    public void mostraCataleg()
    {
        V objecte;
        for (K clau : this.Coleccio.keySet())
        {
            objecte = this.obtenirObjecte(clau);
            System.out.println("[" + objecte.getClau() + "]");
        }
    }
}