package llibrebdexercici;

import java.sql.*;

public class BaseDades
{
    protected String hostname;
    protected int port;
    protected String DBName;

    protected String login;
    protected String password;
    
    protected String URL; //jdbc:mysql://nomhost:3306/nomBD?user=usuari&password=clau;
    protected Connection conexio;

    protected boolean conectat = false;
    
    protected ResultSet resultats;
    
    public BaseDades(String hostname, int port, String DBName, String login, String password)
    {
        this.setHostname(hostname);
        this.setPort(port);
        this.setDBName(DBName);
        this.setLogin(login);
        this.setPassword(password);
        this.setURL();
    }
    
    public void setHostname(String hostname)
    {
        this.hostname = hostname;
    }
    
    public String getHostname()
    {
        return this.hostname;
    }
    
    public void setPort(int port)
    {
        this.port = port;
    }
    
    public float getPort()
    {
        return this.port;
    }
    
    public void setDBName(String DBName)
    {
        this.DBName = DBName;
    }
    
    public String getDBName()
    {
        return this.DBName;
    }
    
    public void setLogin(String login)
    {
        this.login = login;
    }
    
    public String getLogin()
    {
        return this.login;
    }
    
    public void setPassword(String password)
    {
        this.password = password;
    }
    
    public String getPassword()
    {
        return this.password;
    }
    
    protected void setURL()
    {
        //jdbc:mysql://nomhost:3306/nomBD?user=usuari&password=clau;
        this.URL = "jdbc:mysql://" + this.getHostname() + ":" + (int) this.getPort() + "/" + this.getDBName() + "?user=" + this.getLogin() + "&password=" + this.getPassword();
        //this.URL = "jdbc:mysql://" + this.getHostname() + "/" + this.getDBName();//?user=" + this.getLogin() + "&password=" + this.getPassword();
    }
    
    public String getURL()
    {
        return this.URL;
    }
    
    public void setConectat(boolean conectat)
    {
        this.conectat = conectat;
    }
    
    public boolean getConectat()
    {
        return this.conectat;
    }
    
    public void setResultats(ResultSet resultats)
    {
        this.resultats = resultats;
    }
    
    public ResultSet getResultats()
    {
        return this.resultats;
    }
            
    public boolean conecta() throws Exception
    {
        boolean conectat = false;
        
        //Si no esta conectat, conecta:
        if (!this.getConectat())
        {
            DriverManager.registerDriver(new com.mysql.jdbc.Driver());
            //this.conexio = DriverManager.getConnection(this.getURL(), this.getLogin(), this.getPassword());
            this.conexio = DriverManager.getConnection(this.getURL());
            //Si ha conectat, ho fica:
            if (conexio != null)
            {
                conectat = true;
                this.setConectat(conectat);
            }
        }
        return conectat;
    }
    
    public boolean desconecta() //throws Exception
    {
        boolean desconectat = false;

        //Si esta conectat, desconecta:
        if (this.getConectat())
        {
            try
            {
                this.conexio.close();
                desconectat = true;
                this.setConectat(!desconectat);
            }
            catch (Exception e) { System.out.println("Excepcio: " + e.getMessage()); }
        }
        
        return desconectat;
    }
    
    public boolean consulta(String consulta) throws Exception
    {
        boolean totBe = false;
        
        if (this.getConectat() && consulta.trim() != "")
        {
            Statement sentencia = this.conexio.createStatement();
            
            ResultSet resultat = sentencia.executeQuery(consulta);
            
            totBe = true; //No es pot mirar si resultat es null perque mai ho es.

            this.setResultats(resultat);
            
            //Si es tanca, dona error (?):
            //sentencia.close();
        }
        
        return totBe;
    }
    
    public boolean consultaModificacio(String consultaModificacio) throws Exception
    {
        boolean totBe = false;
        
        if (this.getConectat() && consultaModificacio.trim() != "")
        {
            Statement sentencia = this.conexio.createStatement();
            
            int numeroResultats = sentencia.executeUpdate(consultaModificacio);
            
            totBe = true; //No es pot mirar si resultat es null perque mai ho es.

            sentencia.close();
        }
        
        return totBe;
    }
}
