/*
 * Finestra.java
 *
 * Created on 15 de enero de 2008, 15:40
 */

package llibrebdexercici;

import javax.swing.JOptionPane;

/**
 *
 * @author  dai
 */
public class Finestra extends javax.swing.JFrame {
    
    /** Creates new form Finestra */
    public Finestra() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        ISBNTextBox = new javax.swing.JTextField();
        EditorialTextBox = new javax.swing.JTextField();
        AutorTextBox = new javax.swing.JTextField();
        TitolTextBox = new javax.swing.JTextField();
        PreuTextBox = new javax.swing.JTextField();
        cercaButton = new javax.swing.JButton();
        modificaButton = new javax.swing.JButton();
        InsertaButton = new javax.swing.JButton();
        esborraButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Base de Dades Llibres");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jLabel1.setText("ISBN:");

        jLabel2.setText("Editorial:");

        jLabel3.setText("Autor:");

        jLabel4.setText("T\u00edtol:");

        jLabel5.setText("Preu:");

        ISBNTextBox.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                ISBNTextBoxKeyTyped(evt);
            }
        });

        cercaButton.setText("Cerca");
        cercaButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cercaButtonActionPerformed(evt);
            }
        });

        modificaButton.setText("Modifica");
        modificaButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                modificaButtonActionPerformed(evt);
            }
        });

        InsertaButton.setText("Inserta");
        InsertaButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                InsertaButtonActionPerformed(evt);
            }
        });

        esborraButton.setText("Esborra");
        esborraButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                esborraButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1)
                            .addComponent(jLabel2)
                            .addComponent(jLabel3)
                            .addComponent(jLabel4)
                            .addComponent(jLabel5))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(TitolTextBox, javax.swing.GroupLayout.DEFAULT_SIZE, 173, Short.MAX_VALUE)
                            .addComponent(AutorTextBox, javax.swing.GroupLayout.DEFAULT_SIZE, 173, Short.MAX_VALUE)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addComponent(ISBNTextBox, javax.swing.GroupLayout.DEFAULT_SIZE, 106, Short.MAX_VALUE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(cercaButton))
                            .addComponent(PreuTextBox, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(EditorialTextBox, javax.swing.GroupLayout.DEFAULT_SIZE, 173, Short.MAX_VALUE)))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(modificaButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(InsertaButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(esborraButton)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(cercaButton)
                    .addComponent(ISBNTextBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(EditorialTextBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(AutorTextBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(TitolTextBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5)
                    .addComponent(PreuTextBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(modificaButton)
                    .addComponent(InsertaButton)
                    .addComponent(esborraButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        Main.desconectaBD();
    }//GEN-LAST:event_formWindowClosing

    private void esborraButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_esborraButtonActionPerformed
            String ISBN = ISBNTextBox.getText().trim();
            if (ISBN.equals("")) { JOptionPane.showMessageDialog(this, "No has ficat un ISBN!"); return; }
            Llibre llibre = Main.agafaLlibre(ISBN);        
            //Si no existeix, es pot insertar:
            if (llibre != null)
            {
                try
                {
                    Main.esborraLlibre(llibre);
                    llibre = Main.agafaLlibre(ISBN);
                    if (llibre == null) { JOptionPane.showMessageDialog(this, "Llibre esborrat correctament."); }
                } catch (Exception e) { System.out.println("Excepcio: " + e.getMessage()); }
            } else { JOptionPane.showMessageDialog(this, "El llibre no existeix! No es pot esborrar"); }
    }//GEN-LAST:event_esborraButtonActionPerformed

    private void InsertaButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_InsertaButtonActionPerformed
            String ISBN = ISBNTextBox.getText().trim();
            if (ISBN.equals("")) { JOptionPane.showMessageDialog(this, "No has ficat un ISBN!"); return; }
            Llibre llibre = Main.agafaLlibre(ISBN);        
            //Si no existeix, es pot insertar:
            if (llibre == null)
            {
                String editorial = EditorialTextBox.getText();
                String autor = AutorTextBox.getText();
                String titol = TitolTextBox.getText();
                float preu = Float.parseFloat(PreuTextBox.getText());

                if (!ISBN.equals("") && !editorial.equals("") && !autor.equals("") && !titol.equals("") && preu >= 0)
                {
                    try
                    {
                        llibre = new Llibre(ISBN, titol, autor, editorial, preu);
                        Main.insereixLlibre(llibre);
                    } catch (Exception e) { System.out.println("Excepcio: " + e.getMessage()); }
                } else { JOptionPane.showMessageDialog(this, "S'han d'omplir tots els camps i amb valors correctes!"); }
            } else { JOptionPane.showMessageDialog(this, "El llibre ja existeix! Intenta modificar-lo"); }

    }//GEN-LAST:event_InsertaButtonActionPerformed

    private void modificaButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_modificaButtonActionPerformed
        String ISBN = ISBNTextBox.getText().trim();
        if (ISBN.equals("")) { JOptionPane.showMessageDialog(this, "No has ficat un ISBN!"); return; }
        Llibre llibre = Main.agafaLlibre(ISBN);
        //Si el llibre existeix, es modifica:
        if (llibre != null)
        {
            String editorial = EditorialTextBox.getText().trim();
            String autor = AutorTextBox.getText().trim();
            String titol = TitolTextBox.getText().trim();
            float preu = Float.parseFloat(PreuTextBox.getText().trim());
            
            //if (ISBN != "" && editorial != "" && autor != "" && titol != "" && preu >= 0)
            if (!ISBN.equals("") && !editorial.equals("") && !autor.equals("") && !titol.equals("") && preu >= 0)
            {
                try
                {
                    Main.modificaLlibre(llibre, ISBN, titol, autor, editorial, preu);
                } catch (Exception e) { System.out.println("Excepcio: " + e.getMessage()); }
            } else { JOptionPane.showMessageDialog(this, "S'han d'omplir tots els camps i amb valors correctes!"); }
        } else { JOptionPane.showMessageDialog(this, "No existeix un llibre amb ISBN " + ISBN + ", intenta insertar-lo primer!"); }
    }//GEN-LAST:event_modificaButtonActionPerformed

    private void cercaButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cercaButtonActionPerformed
        //Si l'ISBN que s'ha insertat existeix, el carrega:
        String ISBN = ISBNTextBox.getText().trim();

        if (ISBN.equals("")) { JOptionPane.showMessageDialog(this, "No has ficat un ISBN!"); return; }
        //if (ISBN == "") { JOptionPane.showMessageDialog(this, "No has ficat un ISBN!"); return; }
        //if (ISBNTextBox.getText().equals("")) { JOptionPane.showMessageDialog(this, "No has ficat un ISBN!"); return; }
        Llibre llibre = Main.agafaLlibre(ISBN);        
        
        if (llibre != null)
        {
            carregaDades(ISBN);
        } else { JOptionPane.showMessageDialog(this, "No existeix un llibre amb ISBN " + ISBN); }
    }//GEN-LAST:event_cercaButtonActionPerformed

    private void ISBNTextBoxKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_ISBNTextBoxKeyTyped
        //NOTA: si no li sumo el caracter que s'acaba de ficar, no l'agafa:
        //String ultimaTecla = evt.getKeyText(evt.getKeyCode());
        //System.out.println("esto: " + ultimaTecla);
        //System.out.println("esto: " + evt.getKeyCode());
        //System.out.println("esto: " + evt.getKeyLocation());
        //String caracterUltimaTecla = "";
        //if (ultimaTecla.length() == 1) { caracterUltimaTecla = ultimaTecla; }
        //String ISBN = ISBNTextBox.getText().trim() + caracterUltimaTecla;
        
        String ISBN = ISBNTextBox.getText().trim() + (""+evt.getKeyChar()).trim();
        
        //String ISBN = ISBNTextBox.getText().trim();
        if (ISBN.equals("")) { this.buidaDades(); return; }
        
        //System.out.println("Cercant " + ISBN + "...");
        
        //NOTA: son moltes consultes solament al escriure una lletra, pero asumirem que es una consulta local i en una base de dades petita.
        //NOTA2: es dolent si tenim dades escrites i per escriure un altre ISBN hi ha algun llibre amb aquest i esborra les nostres dades escrites.
        
        //Si l'ISBN que s'ha insertat existeix, el carrega:
        Llibre llibre = Main.agafaLlibre(ISBN);
        if (llibre != null)
        {
            this.carregaDades(llibre);
        }
        else
        {
            //this.buidaDades();
        }
    }//GEN-LAST:event_ISBNTextBoxKeyTyped

    public void carregaDades(String ISBN)
    {
        //Si existeix un llibre amb l'ISBN, omple el formulari:
        Llibre llibreCercat = Main.agafaLlibre(ISBN);
        if (llibreCercat != null)
        {
            this.carregaDades(llibreCercat);
        }
    }
    
    public void carregaDades(Llibre llibre)
    {
        if (llibre == null) { return; }
        
        //editorial, autor, titol, preu
        String editorial = llibre.getEditorial();
        String autor = llibre.getAutor();
        String titol = llibre.getTitol();
        float preu = llibre.getPreu();

        EditorialTextBox.setText(editorial);
        AutorTextBox.setText(autor);
        TitolTextBox.setText(titol);
        PreuTextBox.setText("" + preu);
    }

    public void buidaDades()
    {
        EditorialTextBox.setText("");
        AutorTextBox.setText("");
        TitolTextBox.setText("");
        PreuTextBox.setText("");
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                Main.finestra.setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField AutorTextBox;
    private javax.swing.JTextField EditorialTextBox;
    private javax.swing.JTextField ISBNTextBox;
    private javax.swing.JButton InsertaButton;
    private javax.swing.JTextField PreuTextBox;
    private javax.swing.JTextField TitolTextBox;
    private javax.swing.JButton cercaButton;
    private javax.swing.JButton esborraButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JButton modificaButton;
    // End of variables declaration//GEN-END:variables
    
}
