package llibrebdexercici;

public class Main
{
    public static Finestra finestra;
    
    public static BaseDades BD;
    
    protected static final String hostname = "127.0.0.1";
    protected static final int port = 3306;
    protected static final String DBName = "bdllibres";

    protected static final String login = "root";
    protected static final String password = "";

    
    public Main()
    {
    }
    
    public static void main(String[] args)
    {
        Main.mostraFinestra();
        
        try
        {
            Main.conectaBD();
        }
        catch (Exception e) { System.out.println("Excepcio: " + e.getMessage()); }
        //finally { Main.desconectaBD(); }
    }
    
    public static void mostraFinestra()
    {
        Main.finestra = new Finestra();
        Main.finestra.main(null);
    }
    
    public static void conectaBD() throws Exception
    {
        Main.BD = new BaseDades(Main.hostname, Main.port, Main.DBName, Main.login, Main.password);
        Main.BD.conecta();
    }
    
    public static void desconectaBD()
    {
        Main.BD.desconecta();
    }
    
    public static Llibre creaLlibre(String ISBN, String titol, String autor, String editorial, float preu)
    {
        return new Llibre(ISBN, titol, autor, editorial, preu);
    }
    
    public static Llibre agafaLlibre(String ISBN)
    {
        Llibre llibre = null;
        if (Main.BD != null && Main.BD.getConectat())
        {
            try
            {
                llibre = new Llibre(ISBN, Main.BD);;
                if (!llibre.existeixDadesISBN(ISBN, Main.BD)) { llibre = null; }
            } catch (Exception e) { System.out.println("Excepcio: " + e.getMessage()); }
        }
        return llibre;
    }
    
    public static boolean insereixLlibre(Llibre llibre) throws Exception
    {
        if (Main.BD != null && Main.BD.getConectat())
        {
            return llibre.inserirDades(Main.BD);
        } else { return false; }
    }

    public static boolean modificaLlibre(Llibre llibre, String ISBN, String titol, String autor, String editorial, float preu) throws Exception
    {
        if (Main.BD != null && Main.BD.getConectat())
        {
            llibre.setISBN(ISBN);
            llibre.setTitol(titol);
            llibre.setAutor(autor);
            llibre.setEditorial(editorial);
            llibre.setPreu(preu);
            return llibre.modificarDades(Main.BD);
        } else { return false; }
    }
    
    public static boolean esborraLlibre(Llibre llibre) throws Exception
    {
        if (Main.BD != null && Main.BD.getConectat())
        {
            return llibre.esborraDades(Main.BD);
        } else { return false; }
    }
}