package carretcompra;

import java.util.*;

//PROBLEMA: els generic tindrian que anar a nivell de metodes i no de classe, ja que un objecte ha de permitir
//          tot tipus de objectes. Pensar-ho be.
public class CarretCompra<ITEM extends Producte>
{
    private Hashtable<String, ElementCarretCompra<ITEM>> items = new Hashtable<String, ElementCarretCompra<ITEM>>();
    
    public CarretCompra()
    {
    }
    
    public ElementCarretCompra getItem(String referencia)
    {
        return this.items.get(referencia);
    }

    public ElementCarretCompra getItem(ITEM item)
    {
        return this.getItem(item.getReferencia());
    }

    public ElementCarretCompra getItem(ElementCarretCompra element)
    {
        return this.getItem(element.getReferencia());
    }
    
    public boolean eliminaItem(String referencia)
    {
        return (this.items.remove(referencia) != null);
    }

    public int getQuantitatItem(String referencia)
    {
        int quantitat = 0;
        if (existeixItem(referencia)) { quantitat = this.getItem(referencia).getQuantitat(); }
        return quantitat;
    }

    public int getQuantitatItem(ITEM item)
    {
        return getQuantitatItem(item.getReferencia());
    }
    
    public int getQuantitatItem(ElementCarretCompra element)
    {
        return getQuantitatItem(element.getReferencia());
    }
    
    public boolean existeixItem(ITEM item)
    {
        return existeixItem(item.getReferencia());
    }

    public boolean existeixItem(ElementCarretCompra element)
    {
        return existeixItem(element.getReferencia());
    }
    
    public boolean existeixItem(String referencia)
    {
        return (this.getItem(referencia) != null);
    }

    public void incrementaItem(ITEM item) throws ExceptionECC
    {
        this.incrementaItem(item.getReferencia());
    }
    
    public void decrementaItem(ITEM item) throws ExceptionECC
    {
        this.decrementaItem(item.getReferencia());
    }

    public void incrementaItem(ElementCarretCompra element) throws ExceptionECC
    {
        this.incrementaItem(element.getReferencia());
    }
    
    public void decrementaItem(ElementCarretCompra element) throws ExceptionECC
    {
        this.decrementaItem(element.getReferencia());
    }
    
    public void incrementaItem(String referencia) throws ExceptionECC
    {
        if (this.existeixItem(referencia))
        {
            int quantitat = this.getItem(referencia).getQuantitat();
            this.actualitzaQuantitatItem(referencia, quantitat + 1);
        }
    }
    
    public void decrementaItem(String referencia) throws ExceptionECC
    {
        if (this.existeixItem(referencia))
        {
            int quantitat = this.getItem(referencia).getQuantitat();
            this.actualitzaQuantitatItem(referencia, quantitat - 1);
        }
    }

    public void actualitzaQuantitatItem(String referencia, int quantitat) throws ExceptionECC
    {
        this.getItem(referencia).setQuantitat(quantitat);
    }
    
    public void incrementaItem(ITEM item, int increment) throws ExceptionECC
    {
        this.incrementaItem(item.getReferencia(), increment);
    }

    public void decrementaItem(ITEM item, int decrement) throws ExceptionECC
    {
        this.decrementaItem(item.getReferencia(), decrement);
    }

    public void incrementaItem(ElementCarretCompra element, int increment) throws ExceptionECC
    {
        this.incrementaItem(element.getReferencia(), increment);
    }

    public void decrementaItem(ElementCarretCompra element, int decrement) throws ExceptionECC
    {
        this.decrementaItem(element.getReferencia(), decrement);
    }
    
    public void incrementaItem(String referencia, int increment) throws ExceptionECC
    {
        while (increment-- > 0) { this.incrementaItem(referencia); }
    }

    public void decrementaItem(String referencia, int decrement) throws ExceptionECC
    {
        while (decrement-- > 0) { this.decrementaItem(referencia); }
    }
    
    public void afegeixItem(ITEM item) throws ExceptionECC
    {
        //Si no existeix, ficara 1 de quantitat:
        afegeixItem(item, this.getQuantitatItem(item.getReferencia()) + 1);
    }

    public void afegeixItem(ITEM item, int quantitat) throws ExceptionECC
    {
        String referencia = item.getReferencia();
        if (this.existeixItem(item))
        {
            this.getItem(item).setQuantitat(quantitat);
        }
        else
        {
            ElementCarretCompra element = new ElementCarretCompra(item, 1);
            this.items.put(referencia, element);
        }
    }
    
    public int nombreItems()
    {
        return this.items.size();
    }
    
    public void buidar()
    {
        this.items.clear();
    }
    
    public String obtenirItems()
    {
        String cadena = "";
        for(ElementCarretCompra element : this.items.values())
        {
            cadena = element.toString() + "\n";
        }
        return cadena;
    }
    
    public void mostraItems()
    {
        System.out.println(this.obtenirItems());
    }
}