package net;
public class CalculServer extends Server
{
    private static final char[] simbols = { '+', '-', '*', '/' };
    
    public CalculServer(int id, String nom) throws MevaExcepcio
    {
        super(id, nom);
    }

    public String getResponse(String[] parametres) throws NetException
    {
        return CalculServer.Calcula(parametres);
    }
    
    public static String Calcula(String[] parametres) throws NetException
    {
        String resposta = "";
            
        if (parametres.length < 3) { throw new NetException("Parametres insuficients!"); }
        else if (parametres.length > 3) { throw new NetException("Solament 3 parametres!"); }
        else
        {
            String simbol = "";
            double operant1 = 0, operant2 = 0;
            try
            {
                simbol = parametres[0].trim();
                operant1 = Double.parseDouble(parametres[1].trim());
                operant2 = Double.parseDouble(parametres[2].trim());
            }
            catch (Exception e)
            {
                System.out.println("Excepcio al recollir parametres: " + e.getMessage());
            }
            
            if (!CalculServer.simbolValid(simbol)) { throw new NetException("Simbol d'operacio inexistent!"); }
            if (simbol == "/" && operant2 == 0) { throw new NetException("No es pot dividir entre zero!"); }
            else
            {
                //switch (simbol)
                //{
                    //case "+":
                        if (simbol == "+") { resposta = "" + CalculServer.Suma(operant1, operant2); }
                        //break;
                    //case "-":
                        else if (simbol == "-") { resposta = "" + CalculServer.Resta(operant1, operant2); }
                        //break;
                    //case "*":
                        else if (simbol == "*") { resposta = "" + CalculServer.Multiplica(operant1, operant2); }
                        //break;
                    //case "/":
                        else if (simbol == "/") { resposta = "" + CalculServer.Divideix(operant1, operant2); }
                        //break;
                //}
            }
        }
        return resposta;
    }
    
    public static boolean simbolValid(String simbolEnviat)
    {
        char simbol = simbolEnviat.trim().charAt(0);
        boolean existeix = false;
        
        for (int x = 0; x < CalculServer.simbols.length && !existeix; x++)
        {
            if (simbols[x] == simbol) { existeix = true; }
        }
        
        return existeix;
    }
    
    private static double Suma(double a, double b)
    {
        return a+b;
    }

    private static double Resta(double a, double b)
    {
        return a-b;
    }

    private static double Multiplica(double a, double b)
    {
        return a*b;
    }

    private static double Divideix(double a, double b)
    {
        return a/b;
    }

    public String toString()
    {
        return super.toString(); //Es lo mateix que no implementar-lo (es podrien haber imprimit els simbols).
    }
    
    public boolean equals(Object ob)
    {
        return super.equals((Server) ob);
    }
}
