package net;
import java.util.*;

public class TimeServer extends Server
{
    Calendar calendari;
    
    public TimeServer(int id, String nom) throws MevaExcepcio
    {
        super(id, nom);
        this.startCalendari();
    }
    
    public void startCalendari()
    {
        this.calendari = Calendar.getInstance();
    }
    
    private Calendar getCalendari()
    {
        return this.calendari;
    }
    
    //En lloc d'un String, podria retornar una classe Hora:
    public String getResponse(String[] array) throws NetException
    {
        String resposta = this.getHora() + ":" + this.getMinuts() + ":" + this.getSegons();
        return resposta;
    }
    
    public String toString()
    {
        try
        {
            return "[" + this.getId() + "] " + this.getNom() + " [" + this.getResponse(null) + "]";
        }
        catch (NetException e)
        {
            System.out.println("[NetException] El calendari no existeix!");
            return "";
        }
    }
    
    public boolean equals(Object ob)
    {
        return super.equals((Server) ob);
    }

    
    public String getHora() throws NetException
    {
        if (this.getCalendari() == null) { throw new NetException("El calendari no existeix!"); }
        String hora = "" + this.getCalendari().get(Calendar.HOUR);
        return hora;
    }
    
    public String getMinuts() throws NetException
    {
        if (this.getCalendari() == null) { throw new NetException("El calendari no existeix!"); }
        String minuts = "" + this.getCalendari().get(Calendar.MINUTE);
        return minuts;
    }
    
    public String getSegons() throws NetException
    {
        if (this.getCalendari() == null) { throw new NetException("El calendari no existeix!"); }
        String segons = "" + this.getCalendari().get(Calendar.SECOND);
        return segons;
    }

}
