package beans;

import org.apache.struts.action.*;

public class FormulariVeureGuardaBean extends ActionForm
{
    private String boto = "";
    private String pressupost = "";
    private boolean veurePressupost = false;
    
    public FormulariVeureGuardaBean()
    {
    }

    public FormulariVeureGuardaBean(String boto)
    {
        this();
        this.setBoto(boto);
    }
    
    public FormulariVeureGuardaBean(String boto, String pressupost)
    {
        this(boto);
        this.setPressupost(pressupost);
    }

    public FormulariVeureGuardaBean(String boto, String pressupost, boolean veurePressupost)
    {
        this(boto, pressupost);
        this.setVeurePressupost(veurePressupost);
    }
    
    public String getBoto()
    {
        return boto;
    }

    public void setBoto(String boto)
    {
        this.boto = boto;
    }

    public String getPressupost()
    {
        if (this.veurePressupost)
        {
            if (pressupost.trim().equals(""))
            {
                return "<br><br><b>No hi han pressupostos guardats.</b>";
            }
            else
            {
                return pressupost;
            }
        }
        else
        {
            return "";
        }
    }

    public void setPressupost(String pressupost)
    {
        this.pressupost = pressupost;
    }

    public boolean isVeurePressupost()
    {
        return veurePressupost;
    }

    public void setVeurePressupost(boolean veurePressupost)
    {
        this.veurePressupost = veurePressupost;
    }
}