package examen;

import java.sql.*;

public class Salud //Nota: per fer-ho mes simplificat, no fa excepcions ni casi res.
{
    protected String usuari;
    protected float pes = 0;
    protected float altura = 0;
    protected float imc = 0;
    protected BD bd;
    
    static final public float maximPes = 300;
    static final public float maximAltura = 3;
    
    public Salud(String usuari, float pes, float altura, BD bd)
    {
        this.setUsuari(usuari);
        this.setPes(pes);
        this.setAltura(altura);
        this.setBd(bd);
        this.setImc();
    }

    public String getUsuari()
    {
        return usuari;
    }

    public void setUsuari(String usuari)
    {
        if (usuari != null && usuari.trim() != "") { this.usuari = usuari.trim(); }
    }

    public float getPes()
    {
        return pes;
    }

    public void setPes(float pes)
    {
        if (pes > 0) { this.pes = pes; }
    }

    public float getAltura()
    {
        return altura;
    }

    public void setAltura(float altura)
    {
        if (altura > 0) { this.altura = altura; }
    }

    public float getImc()
    {
        return imc;
    }

    public void setImc()
    {
        if (this.getAltura() != 0) { this.imc = this.getPes() / (float)Math.pow(this.getAltura(), 2); }
    }

    public BD getBd()
    {
        return bd;
    }

    public void setBd(BD bd)
    {
        if (bd != null) { this.bd = bd; }
    }
    
    public boolean dadesCorrectes()
    {
        boolean correctes = true;
        
        correctes = (this.getUsuari() != null && this.getUsuari() != "" && this.getBd() != null && this.getAltura() > 0 && this.getPes() > 0 && this.getImc() > 0 && this.getPes() <= Salud.maximPes && this.getAltura() <= Salud.maximAltura);
        
        return correctes;
    }
    
    public boolean insereixRegistre() throws Exception
    {
        boolean totBe = true;
        
        if (!this.dadesCorrectes()) { return false; } //Ja comprova que bd no sigui null.
        
        int transactionLevelBackup = bd.conexio.getTransactionIsolation();
        boolean autocomitBackup = bd.getAutoComit();
        
        try
        {
            //Fica el nivell d'aillament per evitar lectures brutes i guarda l'actual:
            //int transactionLevelBackup = bd.conexio.getTransactionIsolation();
            bd.conexio.setTransactionIsolation(bd.conexio.TRANSACTION_SERIALIZABLE); //Es el mes segur pero el mes lent.
        
            //Guarda el autocomit actual i el fica a false:
            //boolean autocomitBackup = bd.getAutoComit();
            bd.setAutoComit(false);
        
            //Prepara el statment:
            Statement stmt = bd.conexio.createStatement();
            //Nota: per la data actual faig servir CURDATE() (crec que tambe aniria now()).
            stmt.addBatch("INSERT INTO salud(login, data, imc) VALUES('" + this.getUsuari() + "', CURDATE(), " + this.getImc() + ")");
        
            //Executa l'instruccio:
            int[] filesFicades = stmt.executeBatch();
        
            //Si no s'ha inserit res, fa rollback (per si de cas):
            if (filesFicades[0] <= 0)
            {
                bd.rollback();
            }
            //...si no, fa el commit:
            else { bd.commit(); } //bd.conexio.commit(); 
                
            //Restaura l'anterior autocommit i el transaction level:
            //bd.setAutoComit(autocomitBackup);
            //bd.conexio.setTransactionIsolation(transactionLevelBackup);
        }
        //Si ha anat malament, fa rollback:
        catch (Exception e)
        {
            bd.rollback();
            throw e;
        }
        finally
        {
            //Restaura l'anterior autocommit i el transaction level:
            bd.setAutoComit(autocomitBackup);
            bd.conexio.setTransactionIsolation(transactionLevelBackup);
        }
            
        return totBe;
    }
    
    public String getMissatgeImc()
    {
        String missatge = "";
        float imc = this.getImc();
        
        if (imc < 18.5) { missatge = "estas massa prim, tens malnutricio."; }
        if (imc >= 18.5 && imc < 25) { missatge = "estas saludable"; }
        if (imc >= 25 && imc < 30) { missatge = "tens sobrepes"; }
        if (imc >= 30 && imc < 40) { missatge = "obesitat lleu"; }
        if (imc >= 40) { missatge = "tens obesitat morbida, t'has d'operar"; }
        
        return missatge;
    }
}
