package examen;

import java.io.*;
import java.net.*;
import javax.crypto.NullCipher;

import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;

public class ServletEntrada extends HttpServlet
{
    public BD bd = null;
    public PoolBD poolDB = null;
    public PrintWriter out = null;
    
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException
    {
        response.setContentType("text/html;charset=UTF-8");
        
        this.out = response.getWriter();
        
        //String autor = request.getParameter("autor");
        //if (autor != null) { autor = autor.trim(); }
        
        //Agafa una base de dades amb una connexio:
        try
        {
            this.bd = this.poolDB.extreureBD();
        
            //Si no s'ha pogut agafar una connexio, ho notifica i surt:
            if (this.bd == null || !this.bd.getConectat()) { response.sendRedirect("ocupat.html"); return; }
        
            //Si no existeix un objecte Usuari de sessio, surt cap el login:
            HttpSession sessio = request.getSession();
            Usuari usuari = (Usuari) sessio.getAttribute("usuari");
            if (usuari == null) { response.sendRedirect("login.html?missatge=Identifiacio+obligatoria"); }

            //Mostra el formulari:
            String formulariHTML = this.formulariHTML();
            out.println(formulariHTML);
        }
        catch (Exception e) { this.log("Excepcio: " + e.getMessage()); } //No redirigim.
        finally
        {
            if (this.bd != null) { this.poolDB.alliberarConnexi(this.bd); }
            out.close();
        }
    }
       
    public String formulariHTML()
    {
        String formulari;
        
        formulari = "<html>" +
                     "<head>" +
                        "<title>Formulari de la salud</title>" +
                     "</head>" +
                     "<body>" +
                        "<form method=\"post\" action=\"ServletCalculIMC\" name=\"formulari_salud\">" +
                            "Pes (kg, maxim " + Salud.maximPes + "): <input type=\"text\" name=\"pes\" value=\"\" maxlength=\"3\" size=\"3\"><br>" +
                            "Al&ccedil;ada (metres, maxim "+ Salud.maximAltura +"): <input type=\"text\" name=\"altura\" value=\"\" maxlength=\"4\" size=\"4\"><br><br>" +
                            "<input type=\"submit\" name=\"boto\" value=\"Envia\">" +
                        "</form>" +
                        "<form method=\"post\" action=\"ServletLlistatIMC\" name=\"formulari_llistat\">" +
                            "<input type=\"submit\" name=\"boto\" value=\"Veure Llistat\">" +
                        "</form>" +
                     "</body>" +
                     "</html>" + 
                "";
                
        return formulari;
    }
    
    public void init() throws ServletException
    {
        super.init();
        
        ServletContext app = this.getServletContext();
        
        //Recull l'objecte d'application:
        Object elmeupool = app.getAttribute("elmeupool");
        
        //Si no existeix l'objecte d'application, el crea:
        if (elmeupool == null)
        {
            elmeupool = new PoolBD(); //Lo normal seria utilizar password, etc. des d'aqui, pero ja ho te ficat l'objecte PoolBD (es per fer un exemple, no tinc molt en compte la seguretat).
            app.setAttribute("elmeupool", elmeupool);
        }
        //Fica a la propietat:
        this.poolDB = (PoolBD) elmeupool;
    }
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
// <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */

    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */

    /** Returns a short description of the servlet.
     */

    // </editor-fold>
