package examen;

import java.io.*;
import java.net.*;
import javax.crypto.NullCipher;

import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;

public class ServletValidacio extends HttpServlet
{
    public BD bd = null;
    public PoolBD poolDB = null;
    public PrintWriter out = null;
    
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException
    {
        response.setContentType("text/html;charset=UTF-8");
        
        this.out = response.getWriter();
        
        //Agafa una base de dades amb una connexio:
        try
        {
            this.bd = this.poolDB.extreureBD();
        
            //Si no s'ha pogut agafar una connexio, ho notifica i surt:
            if (this.bd == null || !this.bd.getConectat()) { response.sendRedirect("ocupat.html"); }

            //Recull les dades enviades:
            String usuari = request.getParameter("usuari");
            if (usuari != null) { usuari = usuari.trim(); }
            else { usuari = ""; }
            String clau = request.getParameter("clau");
            if (clau != null) { clau = clau.trim(); }
            else { clau = ""; }
            
            //Si algun parametre no s'ha enviat, torna:
            if (usuari == "" || clau == "") { response.sendRedirect("login.html?missatge=Els+camps+son+obligatoris"); }
            
            //Si l'usuari i la contrasenya son correctes:
            if (this.usuariCorrecte(usuari, clau))
            {
                //Crea un objecte usuari en la sessio:
                Usuari usuariIdentificat = new Usuari(usuari, clau);
                HttpSession sessio = request.getSession();
                sessio.setAttribute("usuari", usuariIdentificat);
           
                //Redirigeix cap a ServletEntrada:
                response.sendRedirect("ServletEntrada");
            }
            //...pero si no es un usuari correcte, torna al login:
            else { response.sendRedirect("login.html?missatge=Login+invalid"); }
        }
        catch (Exception e) { this.log("Excepcio: " + e.getMessage()); } //No redirigim.
        finally
        {
            if (this.bd != null) { this.poolDB.alliberarConnexi(this.bd); }
            out.close();
        }
    }
    
    public boolean usuariCorrecte(String usuari, String clau)
    {
        boolean existeix = false;
        
        //FALTARIA: prevenir sqlinjection en les "variables" usuari i clau.
        
        ResultSet resultats = null;
        try
        {
            resultats = this.bd.consulta("SELECT * FROM users WHERE login LIKE '" + usuari + "' AND password LIKE '" + clau + "'");
            
            //Si hi ha al menys un resultat (no podrian ser mes tampoc), existeix:
            if (resultats != null && resultats.next()) { existeix = true; }
            
        } catch (Exception e) { this.log("Excepcio: " + e.getMessage()); }
        
        return existeix;
    }
    
    public void init() throws ServletException
    {
        super.init();
        
        ServletContext app = this.getServletContext();
        
        //Recull l'objecte d'application:
        Object elmeupool = app.getAttribute("elmeupool");
        
        //Si no existeix l'objecte d'application, el crea:
        if (elmeupool == null)
        {
            elmeupool = new PoolBD(); //Lo normal seria utilizar password, etc. des d'aqui, pero ja ho te ficat l'objecte PoolBD (es per fer un exemple, no tinc molt en compte la seguretat).
            app.setAttribute("elmeupool", elmeupool);
        }
        //Fica a la propietat:
        this.poolDB = (PoolBD) elmeupool;
    }
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
