CREATE OR REPLACE TRIGGER p352e1
BEFORE UPDATE OR DELETE OR INSERT
ON emple
FOR EACH ROW
DECLARE
	datos varchar2(200);
BEGIN
	datos := to_char(sysdate(), 'dd/MM/yyyy');
	datos := datos || ' ' || to_char(sysdate(), 'hh:mm/ss');
	datos := datos || ' ' || :old.emp_no || '(' || :new.emp_no || ')';
	datos := datos || ' ' || :old.apellido || '(' || :new.apellido || ')';
	IF DELETING THEN
		datos := datos || ' ' || '[ESBORRAT]';
	ELSIF INSERTING THEN
		datos := datos || ' ' || '[INSERCIO]';
	ELSE --ELSIF UPDATING THEN
		datos := datos || ' ' || '[ACTUALITZACIO]';
	END IF;
	INSERT INTO auditaemple VALUES(datos);
END;
/