CREATE OR REPLACE TRIGGER p352e2
BEFORE UPDATE
ON emple
FOR EACH ROW
DECLARE
	datos varchar2(600);
BEGIN
	datos := to_char(sysdate(), 'dd/MM/yyyy hh:mm:ss');
	datos := datos || ' ' || :old.emp_no || '(' || :new.emp_no || ')';
	datos := datos || ' ' || :old.apellido || '(' || :new.apellido || ')';
	datos := datos || ' ' || '[MODIFICACIO]';
	IF UPDATING('oficio') THEN
		datos := datos || :old.oficio || '=>' || :new.oficio;
	END IF;
	IF UPDATING('dir') THEN
		datos := datos || :old.dir || '=>' || :new.dir;
	END IF;
	IF UPDATING('fecha_alt') THEN
		datos := datos || :old.fecha_alt || '=>' || :new.fecha_alt;
	END IF;
	IF UPDATING('salario') THEN
		datos := datos || :old.salario || '=>' || :new.salario;
	END IF;
	IF UPDATING('comision') THEN
		datos := datos || :old.comision || '=>' || :new.comision;
	END IF;
	IF UPDATING('dept_no') THEN
		datos := datos || :old.dept_no || '=>' || :new.dept_no;
	END IF;
	INSERT INTO auditaemple VALUES(datos);
END;
/