using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace LoginControl
{
    public partial class LoginControl : UserControl
    {
        public event System.EventHandler LoginSuccess;
        public event System.EventHandler LoginFail;

        public LoginControl()
        {
            InitializeComponent();
        }

        private void loginLabel_Click(object sender, EventArgs e)
        {

        }
        
        public string LoginLabel
        {
            get
            {
                return loginLabel.Text;
            }
            set
            {
                loginLabel.Text = value;
            }
        }

        public string PasswordLabel
        {
            get
            {
                return passwordLabel.Text;
            }
            set
            {
                passwordLabel.Text = value;
            }
        }

        public string LoginText
        {
            get
            {
                return loginText.Text;
            }
            set
            {
                loginText.Text = value;
            }
        }

        public string PasswordText
        {
            get
            {
                return passwordText.Text;
            }
            set
            {
                passwordText.Text = value;
            }
        }

        private void loginButton_Click(object sender, EventArgs e)
        {
            if (LoginText.Length <= 0) { loginError.SetError(loginText, "Please enter an user name"); return;  }
            if (PasswordText.Length <= 0) { loginError.SetError(passwordText, "Please enter a password"); return; }

            if (userNameAndPasswordAreValid(LoginText, PasswordText))
            {
                if (LoginSuccess != null)
                {
                    LoginSuccess(this, new System.EventArgs());
                }
            }
            else
            {
                if (LoginFail != null)
                {
                    LoginFail(this, new System.EventArgs());
                }
            }
        }

        private bool userNameAndPasswordAreValid(string userName, string password)
        {
            return password.Equals("TrustMe");
        }
    }
}
