using System;
using System.Collections.Generic;
using System.Text;

using System.Drawing;

//using System.ComponentModel;
//using System.Data;
using System.Windows.Forms;


namespace WindowsApplication1
{
    class Nombres
    {
        static public Form1 formulari = null; //Formulari que "manega".

        static protected String nomPlantilla = "Juan_"; //Nom que es fica a l'esquerra del nombre.

        static protected int minimNoms = 0; //Minim de noms que generara (incluit).
        static protected int maximNoms = 100; //Maxim de noms que generara (incluit).

        static protected int nomsGenerats = 0; //Nombre de noms generats (tambe es podria utilizar un metode del listbox).

        static public int milisegonsTimer = 100; //Milisegons entre cicle i cicle del timer.
        static protected int milisegonsVidaTimerMaxim = 10000; //Milisegons que trigara el timer en escollir un nombre, com a maxim.
        static protected int milisegonsVidaTimer; //Milisegons escollit aleatoriamente que trigara el timer en escollir un nombre.
        static public int nomEscollit; //Guarda el nombre del nom escollit.

        //static public System.Timers.Timer tm = null;
        static public System.Windows.Forms.Timer tm = null;
        

        //Impedeix instanciacio:
        //private Nombres()
        public Nombres()
        {
        }

        //Omple el listbox amb un quantitat aleatoria de noms:
        static public void ompleListBox()
        {
            //Si el formulari es null, surt:
            if (Nombres.formulari == null) { return; }

            //Si el valor minim es mes gran que el maxim (algu els ha ficat malament), els intercanvia:
            if (minimNoms > maximNoms) { int temp = minimNoms; minimNoms = maximNoms; maximNoms = temp; }

            //Genera un nombre aleatori entre el minim i el maxim (incluits):
            int nombreAleatori = Nombres.minimNoms + (new Random()).Next() % (Nombres.maximNoms - Nombres.minimNoms + 1);

            //Nombres.formulari.Show("El nombre generat es: " + nombreAleatori);

            //Fa un bucle omplint el listbox:
            int totals = nombreAleatori;
            while (nombreAleatori-- > 0)
            {
                Nombres.formulari.listBox.Items.Add(Nombres.nomPlantilla + (totals - nombreAleatori - 1));
            }

            //Guarda el nombre d'elements:
            Nombres.nomsGenerats = totals;
        }

        //Comena el generador:
        static public void generar()
        {
            //Defineix un nombre inicial (com comena per zero, ha de ser menor que el nombre de noms generats pero mai igual):
            Nombres.nomEscollit = (new Random()).Next() % Nombres.nomsGenerats;

            //Defineix el nombre de milisegons que trigara el timer en agafar un numero:
            Nombres.milisegonsVidaTimer = (new Random()).Next() % (Nombres.milisegonsVidaTimerMaxim + 1);

            //Fica el maxim de la barra com els milisegons que triagara el timer:
            Nombres.formulari.progressBar.Value = 0; //La fica a zero per si de cas (no fa falta en aquest exercici).
            Nombres.formulari.progressBar.Minimum = 0; //Podria ser zero.
            Nombres.formulari.progressBar.Maximum = Nombres.milisegonsVidaTimer;

            //Crea el timer:
            //System.Timers.Timer tm = new System.Timers.Timer();
            tm.Interval = Nombres.milisegonsTimer; //Numero de milisegons entre cicle i cicle del timer.
            tm.Enabled = true;
            tm.Start(); //Activa el timer.
            //tm.Elapsed += new System.Timers.ElapsedEventHandler(cicleTimer); //Fa que el timer cridi al metode cicleTimer().
            tm.Tick += new System.EventHandler((new Nombres()).cicleTimer);
        }

        //Funcio que s'executa al finalitzar el generador (al acabar el timer):
        static protected void generarAcabat()
        {
            //Esborra de la llista el nom amb el nombre escollit:
            Nombres.formulari.listBox.Items.RemoveAt(Nombres.nomEscollit);

            //Mostra un missatge:
            MessageBox.Show("L'element esborrat de la llista es del " + Nombres.nomEscollit);

            //Canvia el backcolor dels 2 textbox:
            Nombres.formulari.unitatsTextBox.BackColor = Color.FromArgb(128, 0, 0);
            Nombres.formulari.decenesTextBox.BackColor = Color.FromArgb(0, 0, 128);

            //Desactiva l'opcio del menu generador:
            Nombres.formulari.generarToolStripMenuItem.Enabled = false;

            //Nota: no fa falta desactivar el timer perque hem fet un stop.

            //Nombres.formulari.generarAcabat();
        }

        //Instruccions que fa el timer en cada cicle seu:
        //static protected void cicleTimer(object sender, System.Timers.ElapsedEventArgs e)
        private void cicleTimer(object sender, EventArgs e)
        {
            //Incrementa el numero (si es pasa, dona "la volta"):
            Nombres.nomEscollit++;
            Nombres.nomEscollit = Nombres.nomEscollit % Nombres.nomsGenerats;

            //Actualitza els marcadors:
            Nombres.actualitzaMarcadors();

            //Actualitza la barra:
            Nombres.actualitzaBarra();

            //Resta els milisegons que li quedan al timer:
            Nombres.milisegonsVidaTimer -= Nombres.milisegonsTimer; //Nota: crec que tambe es podria controlar els segons que porta el timer amb el seu metode InitializeLifetimeService.

            //Si ja porta 10 segons o mes, para el cicle:
            if (Nombres.milisegonsVidaTimer <= 0)
            {
                //Recull el timer des del sender i el para:
                //System.Timers.Timer tm = (System.Timers.Timer)sender;
                tm = (System.Windows.Forms.Timer)sender;
                tm.Stop();

                //Crida al metode necessari quan finalitza el timer:
                Nombres.generarAcabat();
            }
        }

        //Actualitza els marcadors de decenes i unitats (los dos textbox):
        static protected void actualitzaMarcadors()
        {
            //Calcula les unitats i les decenes:
            int unitats = Nombres.nomEscollit % 10;
            int decenes = Nombres.nomEscollit / 10;

            //Mostra les unitats i les decenes:
            Nombres.formulari.unitatsTextBox.Text = "" + unitats;
            Nombres.formulari.decenesTextBox.Text = "" + decenes;
            

            //Nombres.formulari.actualitzaMarcadors();
        }

        //Actualitza la barra de progres (progressbar):
        static protected void actualitzaBarra()
        {
            //Li suma el numero de milisegons que ha trigat el cicle del timer:
            if (Nombres.formulari.progressBar.Value + Nombres.milisegonsTimer <= Nombres.formulari.progressBar.Maximum)
            {
                Nombres.formulari.progressBar.Value += Nombres.milisegonsTimer;
            }
            
            //Nombres.formulari.actualitzaBarra();
        }
    }
}
