using System;
using System.Collections.Generic;
using System.Text;

namespace ConsoleApplication1
{
    class Taulell
    {
        protected static readonly int filesDefecte = 8;
        protected static readonly int columnesDefecte = 8;

        protected int files = Taulell.filesDefecte;
        protected int columnes = Taulell.columnesDefecte;

        protected int[,] mapa;

        public Taulell()
        {
            this.inicializarMapa();
        }

        public Taulell(int files, int columnes)
            : this()
        {
            this.setFiles(files);
            this.setColumnes(columnes);
        }

        public int this[int fila, int columna]
        {
            get
            {
                if (this.posicioCorrecta(fila, columna))
                {
                    return this.mapa[fila, columna];
                }
                else { System.Console.WriteLine("Posicio incorrecta: (" + fila + "," + columna + ")."); return 0; }
            }
            set
            {
                if (this.posicioCorrecta(fila, columna))
                {
                    if (value.GetType().ToString() == "System.Int32") //(value.GetType() == TypeOf(0))
                    {
                        this.mapa[fila, columna] = value;
                    }
                    else { System.Console.WriteLine("Tipus incorrecte. El tipus enviat es: " + value.GetType().FullName); }
                }
                else { System.Console.WriteLine("Posicio incorrecta: (" + fila + "," + columna + ")."); }
            }
        }

        public void inicializarMapa()
        {
            this.mapa = new int[this.getFiles(), this.getColumnes()];
            for (int f = 0; f < this.getFiles(); f++)
            {
                for (int c = 0; c < this.getColumnes(); c++)
                {
                    this.mapa[f, c] = 0;
                }
            }
        }

        public void setFiles(int files)
        {
            this.files = files;
            this.modificarDimensio(this.getFiles(), this.getColumnes());
        }

        public int getFiles()
        {
            return this.files;
        }

        public void setColumnes(int columnes)
        {
            this.columnes = columnes;
            this.modificarDimensio(this.getFiles(), this.getColumnes());
        }

        public int getColumnes()
        {
            return this.columnes;
        }

        public bool posicioCorrecta(int fila, int columna)
        {
            bool totBe = true;
            if (fila < 0 || fila >= this.getFiles()) { totBe = false; }
            if (columna < 0 || columna >= this.getColumnes()) { totBe = false; }
            return totBe;
        }

        protected void modificarDimensio(int files, int columnes)
        {
            //Crea un mapa amb la nova dimensio:
            int[,] mapaNou = new int[files, columnes];

            //Copia lo que pot de l'antic mapa al nou mapa:
            for (int f = 0; f < files; f++)
            {
                for (int c = 0; c < columnes; c++)
                {
                    if (f < this.getFiles() && c < this.getColumnes())
                    {
                        try { mapaNou[f, c] = this.mapa[f, c]; }
                        catch (Exception e) { System.Console.WriteLine(e.GetBaseException()); }
                    }
                    else
                    {
                        mapaNou[f, c] = 0;
                    }
                }
            }
            
            //Fica com a mapa actual el nou mapa:
            this.mapa = mapaNou;
        }
    }
}
