using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using MainFormSpace;

using MySql.Data.MySqlClient;
using MySql.Data.Types;

namespace FormEsborrarSpace
{
    public partial class FormEsborrar : Form
    {
        public FormEsborrar()
        {
            InitializeComponent();
        }

        //Metode que s'executa al obrir aquest formulari:
        private void FormEsborrar_Load(object sender, EventArgs e)
        {
            //Omple el combobox:
            omplirComboBox();
        }

        //Metode que s'executa al fer click en el boto de sortir:
        private void botoSortir_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        //Metode que s'executa al fer click en el boto d'esborrar:
        private void botoEsborrar_Click(object sender, EventArgs e)
        {
            //Esborra el professor que esta seleccionat al combobox:
            String nomProfessor = (String) this.profesCombobox.Items[this.profesCombobox.SelectedIndex];
            this.esborraProfessor(nomProfessor);
        }

        //Metode que omple el combobox amb els profes existents:
        private void omplirComboBox() //Nota: es podria haver fet servir la propietat DataSource del combobox.
        {
            //Esborra el combobox (per si habien items anteriorment):
            this.profesCombobox.Items.Clear();

            //Defineix l'instruccio:
            String instruccio = "SELECT nom_profe FROM profes";

            try
            {
                //Executa la instruccio:
                MySqlDataReader dataReader = MainForm.baseDatos.consulta(instruccio);
                if (dataReader != null)
                {
                    //Recorreix els resultats:
                    while (dataReader.Read())
                    {
                        this.profesCombobox.Items.Add(dataReader.GetString(0));
                    }
                    
                    MainForm.baseDatos.dataReader.Close();

                    //Selecciona el primer profe:
                    this.profesCombobox.SelectedIndex = 0;
                }
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }
        }

        //Metode que esborra un professor escollit:
        private void esborraProfessor(String nomProfessor)
        {
            MessageBox.Show("Esborrant " + nomProfessor + "...");

            try
            {
                //Defineix les instruccions:
                String instruccio1 = "DELETE FROM profes WHERE nom_profe LIKE '" + nomProfessor + "'";
                String instruccio2 = "DELETE FROM matricules WHERE nom_profe LIKE '" + nomProfessor + "'";

                //Executa les instruccions:
                MainForm.baseDatos.modificacion(instruccio1);
                MainForm.baseDatos.dataReader.Close();
                MainForm.baseDatos.modificacion(instruccio2);
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }

            //Torna a carregar el combobox, per si s'ha eliminar correctament:
            this.omplirComboBox();
        }
    }
}