﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsApplication1
{
    public partial class Finestra : Form
    {
        private bool jocIniciat = false;
        private bool jocPausat = true;
        private String pilotaDireccioVertical = "abaix";
        private String pilotaDireccioHorizontal = "esquerra";
        private int topeVertical = 380;
        private int topeHorizontal = 550;
        private int barraTitolHeight = 40;
        private int usuariGols = 0;
        private int ordinadorGols = 0;
        private const int pilotaIncrementYinicial = 4;
        private const int pilotaIncrementXinicial = 4;
        private int pilotaIncrementY = pilotaIncrementYinicial;
        private int pilotaIncrementX = pilotaIncrementXinicial;

        public Finestra()
        {
            InitializeComponent();
        }

        private void mourePaletaUsuari(object sender, MouseEventArgs e)
        {
            if (!this.jocIniciat) { return; }

            if (e.Y - (usuari.Height / 2) >= 0 && e.Y - (usuari.Height / 2) <= topeVertical - usuari.Height - barraTitolHeight)
            {
                if (Math.Abs((usuari.Top + usuari.Height / 2) - e.Y) >= 2)
                {
                    usuari.Top = e.Y - (usuari.Height / 2);
                    //ejeY.Text = "" + usuari.Top + " (" + (380 - usuari.Height) + "[" + usuari.Height + "]) => " + (Math.Abs(usuari.Top - e.Y) - (usuari.Height / 2));
                }
            }
        }

        private void mourePaletaOrdinador()
        {
            if (pilota.Top + (pilota.Height / 2) > ordinador.Top + (ordinador.Height / 2))
            {
                if (ordinador.Top + ordinador.Height + pilotaIncrementY <= topeVertical - barraTitolHeight)
                {
                    ordinador.Top += pilotaIncrementY;
                }
            }
            else
            {
                if (ordinador.Top - pilotaIncrementY >= 0)
                {
                    ordinador.Top -= pilotaIncrementY;
                }
            }
        }

        private void Finestra_Load(object sender, EventArgs e)
        {
            mostraMissatge("");
        }

        private void JocInicia()
        {
            this.jocIniciat = true;
            this.jocPausat = false;
            this.usuariGols = this.ordinadorGols = 0;

            this.pilotaIncrementY = Finestra.pilotaIncrementYinicial;
            this.pilotaIncrementX = Finestra.pilotaIncrementXinicial;

            mostraMissatge("");

            CheckForIllegalCrossThreadCalls = false;

            System.Timers.Timer tm = new System.Timers.Timer();
            tm.Interval = 2;
            tm.Enabled = true;
            tm.Start();
            tm.Elapsed += new System.Timers.ElapsedEventHandler(cicleJoc);

            /*while (jocIniciat)
            {
                calculaColisio();
                mourePilota();
                calculaGol();
                mourePaletaUsuari(null, Events.);
            }*/
        }

        private void cicleJoc(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (!this.jocIniciat) { return; }
            if (this.jocPausat) { return; }

            calculaColisio();
            mourePilota();
            mourePaletaOrdinador();
            calculaGol();
        }

        private void botoStart_Click(object sender, EventArgs e)
        {
            botoStart.Visible = false;
            JocInicia();
        }

        private void mourePilota()
        {
            if (pilotaDireccioVertical == "abaix")
            {
                pilota.Top += pilotaIncrementY;
            }
            else
            {
                if (pilota.Top - pilotaIncrementY >= 0) { pilota.Top -= pilotaIncrementY; }
                else { pilota.Top = 0; }
            }

            if (pilotaDireccioHorizontal == "esquerra")
            {
                if (pilota.Left - pilotaIncrementX >= 0) { pilota.Left -= pilotaIncrementX; }
                else { pilota.Left = 0; }
            }
            else
            {
                pilota.Left += pilotaIncrementX;
            }

            //MessageBox.Show(""+pilota.Top);
        }

        private void calculaColisio()
        {
            int[] incrementsVerticals = { 15, 12, 10, 8, 7, 6, 5, 4, 3, 4, 5, 6, 7, 8, 10, 12, 15 };
            int partPaletaColisio = 0; //5;

            if (pilota.Top + pilota.Height >= usuari.Top && pilota.Top <= usuari.Top + usuari.Height)
            {
                if (pilota.Left + pilota.Width >= usuari.Left && pilota.Left <= usuari.Left + usuari.Width)
                {
                    pilotaDireccioHorizontal = "dreta";
                    //pilotaDireccioVertical = (pilotaDireccioVertical == "abaix") ? "adalt" : "abaix";
                    partPaletaColisio = (int) ( ((pilota.Top + pilota.Height) - usuari.Top) / (float) usuari.Height * incrementsVerticals.Length );
                    partPaletaColisio %= incrementsVerticals.Length;
                    pilotaIncrementY = incrementsVerticals[partPaletaColisio];
                    mostraMissatge("((" + pilota.Top + " + " + pilota.Height + ") - " + usuari.Top + ") / " + usuari.Height + " * " + incrementsVerticals.Length + " = " + partPaletaColisio + " (" + pilotaDireccioHorizontal + ") => " + pilotaIncrementY);
                }
            }

            if (pilota.Top + pilota.Height >= ordinador.Top && pilota.Top <= ordinador.Top + ordinador.Height)
            {
                if (pilota.Left + pilota.Width >= ordinador.Left && pilota.Left <= ordinador.Left + ordinador.Width)
                {
                    pilotaDireccioHorizontal = "esquerra";
                    //pilotaDireccioVertical = (pilotaDireccioVertical == "abaix") ? "adalt" : "abaix";
                    partPaletaColisio = (int) ( ((pilota.Top + pilota.Height) - ordinador.Top) / (float) ordinador.Height * incrementsVerticals.Length );
                    partPaletaColisio %= incrementsVerticals.Length;
                    pilotaIncrementY = incrementsVerticals[partPaletaColisio];
                    mostraMissatge("((" + pilota.Top + " + " + pilota.Height + ") - " + usuari.Top + ") / " + usuari.Height + " * " + incrementsVerticals.Length + " = " + partPaletaColisio + " (" + pilotaDireccioHorizontal + ") => " + pilotaIncrementY);
                }
            }

            if (pilota.Top <= 0) { pilotaDireccioVertical = "abaix"; }
            else if (pilota.Top + pilota.Height + barraTitolHeight >= topeVertical) { pilotaDireccioVertical = "adalt"; actualitzaMarcadors(); }
        }

        private void calculaGol()
        {
            bool hiHaGol = false;
            String autorGol = "";
            if (pilota.Left <= 0) { pilotaDireccioHorizontal = "dreta"; ordinadorGols++; hiHaGol = true; autorGol = "Ordinador"; }
            else if (pilota.Left >= topeHorizontal) { pilotaDireccioHorizontal = "esquerra"; usuariGols++; hiHaGol = true; autorGol = "Usuari"; }

            if (hiHaGol)
            {
                pilota.Top = (this.topeVertical / 2) - (pilota.Height / 2);
                pilota.Left = (this.topeHorizontal / 2) - (pilota.Width / 2) - barraTitolHeight;
                this.jocPausat = true;

                this.pilotaIncrementY = Finestra.pilotaIncrementYinicial;
                this.pilotaIncrementX = Finestra.pilotaIncrementXinicial;

                actualitzaMarcadors();
                mostraMissatge("Gol del " + autorGol);
                
                //MessageBox.Show("Gol del " + autorGol);

                System.Timers.Timer tmPausa = new System.Timers.Timer();
                tmPausa.Interval = 1000;
                tmPausa.Enabled = true;
                tmPausa.Start();
                tmPausa.Elapsed += new System.Timers.ElapsedEventHandler(treuPausa);
            }
        }

        private void treuPausa(object sender, System.Timers.ElapsedEventArgs e)
        {
            this.jocPausat = false;
            mostraMissatge("");
            ((System.Timers.Timer)sender).Stop();
        }

        private void mostraMissatge(String msg)
        {
            missatge.Text = msg;
        }

        private void actualitzaMarcadors()
        {
            UsuariMarcador.Text = "" + usuariGols;
            OrdinadorMarcador.Text = "" + ordinadorGols;
        }
    }
}