﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ConsoleApplication1
{
    class Program
    {
        static void Main(string[] args)
        {
            string linia1, linia2;
            short x, y;
            char[,] tauler = new char[8, 8];

            inicialitzaTauler(tauler);

            mostraTauler(tauler);

            do
            {
                do
                {
                    System.Console.Write("\nFica la X del alfil (-1 per sortir): ");
                    linia1 = System.Console.ReadLine();
                    if (linia1 == "-1") { break; }
                    else if (short.Parse(linia1) < 0 || short.Parse(linia1) > 7) { System.Console.WriteLine("Ha de ser un numero entre 0 i 7!"); }
                } while (short.Parse(linia1) < 0 || short.Parse(linia1) > 7);
                
                do
                {
                    System.Console.Write("\nFica la Y del alfil (-1 per sortir): ");
                    linia2 = System.Console.ReadLine();
                    if (linia2 == "-1") { break; }
                    else if (short.Parse(linia2) < 0 || short.Parse(linia2) > 7) { System.Console.WriteLine("Ha de ser un numero entre 0 i 7!"); }
                } while (short.Parse(linia2) < 0 || short.Parse(linia2) > 7);

                try
                {
                    x = short.Parse(linia1);
                    y = short.Parse(linia2);
                    calculaMovimentAlfil(tauler, x, y);
                    mostraTauler(tauler);
                }
                catch (System.Exception e)
                {
                    System.Console.WriteLine("S'ha produit una excepcio: " + e.GetBaseException());
                    break;
                }
                finally
                {
                    inicialitzaTauler(tauler);
                }
            } while (1 + 1 == 2);

            System.Console.WriteLine("Adeu!");
        }

        static void inicialitzaTauler(char[,] tauler)
        {
            char casella = 'B';

            for (short x = 0; x < 8; x++)
            {
                for (short y = 0; y < 8; y++)
                {
                    tauler[x, y] = casella;
                    casella = (casella == 'B') ? 'N' : 'B';
                }
            }
        }


        static void mostraTauler(char[,] tauler)
        {
            for (short x = 0; x < 8; x++)
            {
                for (short y = 0; y < 8; y++)
                {
                    System.Console.Write(tauler[x, y] + " ");
                }
                System.Console.WriteLine("");
            }
        }


        static void calculaMovimentAlfil(char[,] tauler, short x, short y)
        {
            short f, c;

            //Superior esquerra:
            for (f = y, c = x; f >= 0 && c >= 0; f--, c--)
            {
                    tauler[f, c] = '*';
            }

            //Superior dreta:
            for (f = y, c = x; f >= 0 && c < 8; f--, c++)
            {
                tauler[f, c] = '*';
            }

            //Inferior esquerra:
            for (f = y, c = x; f < 8 && c >= 0; f++, c--)
            {
                tauler[f, c] = '*';
            }

            //Inferior dreta:
            for (f = y, c = x; f < 8 && c < 8; f++, c++)
            {
                tauler[f, c] = '*';
            }
        }

    }
}
