﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ConsoleApplication1
{
    class Program
    {
        static void Main(string[] args)
        {
            int maxim = 1024, dobles, triples;
            long combinacions;
            int partits = 15;
            bool[,] columna = new bool[partits, 3];

            do
            {
                combinacions = 0;
                dobles = pregunta("dobles", combinacions, maxim, partits);
                combinacions = (long) Math.Pow(2, dobles);
                triples = pregunta("triples", combinacions, maxim, partits);
                combinacions *= (long) Math.Pow(3, triples);
                if (combinacions < 0 || combinacions > maxim) { System.Console.WriteLine("El numero de combinacions ha de ser entre 0 i " + maxim + " (i el teu resultaria de " + combinacions + ")"); }
            } while(combinacions < 0 || combinacions > maxim);

            //System.Console.WriteLine("El numero de combinacions entre dobles i triples es: " + combinacions);

            creaColumna(dobles, triples, columna, partits);

            mostraColumna(columna, partits);

            mostraPreu(dobles, triples);

            System.Console.ReadKey();
        }

        public static int pregunta(string tipus, long combinacions, int maxim, int partits)
        {
            long combinacionsCopia;
            int baseCombinatoria = (tipus.Trim() == "dobles") ? 2 : 3;
            int quantitat;
            do
            {
                combinacionsCopia = combinacions;
                System.Console.Write("\nFica el numero de " + tipus + ": ");
                quantitat = int.Parse(System.Console.ReadLine().Trim());
                if (quantitat > 0) { combinacionsCopia += (long)Math.Pow(baseCombinatoria, quantitat); }
                if (combinacionsCopia < 0 || combinacionsCopia > maxim || quantitat < 0 || quantitat > partits) { System.Console.WriteLine("El numero de combinacions ha de ser entre 0 i " + maxim + " (i el teu resultaria de " + combinacionsCopia + ")"); }
            } while (combinacionsCopia < 0 || combinacionsCopia > maxim || quantitat < 0 || quantitat > partits);
            return quantitat;
        }

        public static void creaColumna(int dobles, int triples, bool[,] columna, int partits)
        {
            bool[] partitsFets = new bool[partits];
            int posicio;
            
            Random random = new Random();

            while (dobles-- > 0)
            {
                do
                {
                    posicio = random.Next() % partits;
                } while (partitsFets[posicio]);
                ferDoble(columna, posicio, random);
                partitsFets[posicio] = true;
            }

            while (triples-- > 0)
            {
                do
                {
                    posicio = random.Next() % partits;
                } while (partitsFets[posicio]);
                ferTriple(columna, posicio);
                partitsFets[posicio] = true;
            }

            for (int x = 0; x < partits; x++)
            {
                if (!partitsFets[x]) { ferSimple(columna, x, random); }
            }

            return;
        }

        public static void ferDoble(bool[,] columna, int posicio, Random random)
        {
            //Random random = new Random();
            int casella1 = random.Next() % 3;
            int casella2;
            do { casella2 = random.Next() % 3; } while (casella1 == casella2);
            columna[posicio, casella1] = columna[posicio, casella2] = true;
            return;
        }

        public static void ferTriple(bool[,] columna, int posicio)
        {
            columna[posicio, 0] = columna[posicio, 1] = columna[posicio, 2] = true;
            return;
        }

        public static void ferSimple(bool[,] columna, int posicio, Random random)
        {
            //Random random = new Random();
            int casella = random.Next() % 3;
            columna[posicio, casella] = true;
            return;
        }

        public static void mostraColumna(bool[,] columna, int partits)
        {
            short contador;
            string[] tipus = { "Simple", "Doble", "Triple" };
            System.Console.WriteLine("\n\nPartit\t[1]\t[X]\t[2]\tTipus\n");
            for (int x = 0; x < partits; x++)
            {
                contador = -1;
                System.Console.Write(x + 1);
                System.Console.Write("\t ");
                if (columna[x, 0]) { System.Console.Write("1"); contador++;  }
                System.Console.Write("\t ");
                if (columna[x, 1]) { System.Console.Write("X"); contador++;  }
                System.Console.Write("\t ");
                if (columna[x, 2]) { System.Console.Write("2"); contador++;  }
                if (contador >= 0) { System.Console.Write("\t" + tipus[contador]); }
                Console.WriteLine("");
            }

            return;
        }

        public static void mostraPreu(int dobles, int triples)
        {
            long combinacions = (long) Math.Pow(2, dobles) * (long) Math.Pow(3, triples);
            double preu = combinacions * 0.5;
            System.Console.WriteLine("\nEl preu es: " + preu + " euros");
            return;
        }
    }
}
