﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ConsoleApplication1
{
    class Program
    {
        private const byte PARTITS = 14;

        static void Main(string[] args)
        {
            byte columnes = preguntaColumnes();
            char[,] quiniela = new char[columnes, PARTITS];
            
            ompleQuiniela(quiniela, columnes);

            mostraQuiniela(quiniela, columnes);

            Console.ReadKey();
        }

        static byte preguntaColumnes()
        {
            byte columnes;
            string cadena;
            
            do
            {
                Console.Write("Fica el numero de columnes, de 1 a 8 (0 per sortir): ");
                cadena = Console.ReadLine();
                if (cadena.Trim() == "") { cadena = "0"; }

                columnes = byte.Parse(cadena);
            } while (columnes < 0 || columnes > 8);

            if (columnes == 0) { Environment.Exit(0); }

            return columnes;
        }

        static void ompleQuiniela(char[,] quiniela, byte columnes)
        {
            char[] valors = { '1', 'X', '2' };
            Random random = new Random();
            for (byte f = 0; f < columnes; f++)
            {
                for (byte c = 0; c < PARTITS; c++)
                {
                    int valor = random.Next() % 3;
                    quiniela[f, c] = valors[valor];
                }
            }
        }

        static void mostraQuiniela(char[,] quiniela, byte columnes)
        {
            for (byte f = 0; f < columnes; f++)
            {
                for (byte c = 0; c < PARTITS; c++)
                {
                    Console.Write(quiniela[f, c] + " ");
                }
                Console.WriteLine();
            }
        }
    }
}
