using System;
using System.Collections.Generic;
using System.Text;

namespace Productes
{
    abstract class Electrodomestic
    {
        protected String marca;
        protected String model;
        protected float potencia;

        public Electrodomestic(String marca, String model, float potencia)
        {
            this.setMarca(marca);
            this.setModel(model);
            this.setPotencia(potencia);
        }

        public String Marca_i_mode()
        {
            return this.getMarca() + " - " + this.getModel();
        }

        public float consum_actual()
        {
            return this.getPotencia();
        }

        public void setMarca(String marca)
        {
            this.marca = marca;
        }

        public void setModel(String model)
        {
            this.model = model;
        }

        public void setPotencia(float potencia)
        {
            this.potencia = potencia;
        }

        public String getMarca()
        {
            return this.marca;
        }

        public String getModel()
        {
            return this.model;
        }

        public float getPotencia()
        {
            return this.potencia;
        }
    }


    sealed class Televisio : Electrodomestic
    {
        private float polsades;
        private bool pantallaPlana;

        public Televisio(String marca, String model, float potencia, float polsades, bool pantallaPlana)
            : base(marca, model, potencia)
        {
            this.setPolsades(polsades);
            this.setPantallaPlana(pantallaPlana);
        }

        public float Mides_pantalla()
        {
            return this.getPolsades();
        }

        public String Pantalla_Plana()
        {
            return (this.getPantallaPlana()) ? "Si" : "No";
        }

        public void setPolsades(float polsades)
        {
            this.polsades = polsades;
        }

        public void setPantallaPlana(bool pantallaPlana)
        {
            this.pantallaPlana = pantallaPlana;
        }

        public float getPolsades()
        {
            return this.polsades;
        }

        public bool getPantallaPlana()
        {
            return this.pantallaPlana;
        }
    }


    sealed class Rentadora : Electrodomestic
    {
        private float revolucions;

        public Rentadora(String marca, String model, float potencia, float revolucions)
            : base(marca, model, potencia)
        {
            this.setRevolucions(revolucions);
        }

        public float Velocitat_de_rentat()
        {
            return this.getRevolucions();
        }

        public void setRevolucions(float revolucions)
        {
            this.revolucions = revolucions;
        }

        public float getRevolucions()
        {
            return this.revolucions;
        }
    }


    class Reproductor : Electrodomestic
    {
        protected bool llegeixRegravables;

        public Reproductor(String marca, String model, float potencia, bool llegeixRegravables)
            : base(marca, model, potencia)
        {
            this.setLleigeixRegrabables(llegeixRegravables);
        }

        public String Llegeix_Regrabables()
        {
            return (this.getLlegeixRegrabables()) ? "Si" : "No";
        }


        public void setLleigeixRegrabables(bool llegeixRegravables)
        {
            this.llegeixRegravables = llegeixRegravables;
        }

        public bool getLlegeixRegrabables()
        {
            return this.llegeixRegravables;
        }
    }


    sealed class Grabador : Reproductor
    {
        private float capacitatDiscDur;

        public Grabador(String marca, String model, float potencia, bool llegeixRegravables, float capacitatDiscDur)
            : base(marca, model, potencia, llegeixRegravables)
        {
            this.setCapacitatDiscDur(capacitatDiscDur);
        }

        public float Capacitat()
        {
            return this.getCapacitatDiscDur();
        }

        public void setCapacitatDiscDur(float capacitatDiscDur)
        {
            this.capacitatDiscDur = capacitatDiscDur;
        }

        public float getCapacitatDiscDur()
        {
            return this.capacitatDiscDur;
        }

        new public bool getLlegeixRegrabables() //Fa lo mateix, pero era per provar el polimorfisme de sobrescriptura.
        {
            return this.llegeixRegravables;
        }
    }
}
