using System;
using System.Collections.Generic;
using System.Text;

namespace ConsoleApplication1
{
    class Angles
    {
        protected int angle = 0; //Graus de l'angle.
        protected int minut = 0; //Minuts de l'angle.
        protected int segon = 0; //Segons de l'angle.

        //Constructor que deixa l'angle en 0 0' 0":
        public Angles()
        {
        }

        //Constructor que crea l'angle igual que un altre:
        public Angles(Angles obj)
            : this (obj.getGraus(), obj.getMinuts(), obj.getSegons())
        {
        }

        //Constructor que defineix els graus:
        public Angles(int angle)
            : this()
        {
            this.setAngle(angle);
        }

        //Constructor que defineix els graus i els minuts:
        public Angles(int angle, int minuts)
            : this(angle)
        {
            this.setMinuts(minuts);
        }

        //Constructor que defineix els grais, minuts i els segons:
        public Angles(int angle, int minuts, int segons)
            : this(angle, minuts)
        {
            this.setSegons(segons);
        }

        //Destructor:
        ~Angles()
        {
        
        }

        //Sobrecriu l'operador de suma:
        static public Angles operator +(Angles obj1, Angles obj2)
        {
            //Retorna un objecte amb la suma dels atributs d'ambdos:
            return new Angles(obj1.getGraus() + obj2.getGraus(), obj1.getMinuts() + obj2.getMinuts(), obj1.getSegons() + obj2.getSegons());
        }

        //Sobrecriu l'operador de resta:
        static public Angles operator -(Angles obj1, Angles obj2)
        {
            //Retorna un objecte amb la resta dels atributs d'ambdos:
            return new Angles(obj1.getGraus() - obj2.getGraus(), obj1.getMinuts() - obj2.getMinuts(), obj1.getSegons() - obj2.getSegons());
        }

        //Sobrecriu l'operador de comparacio d'igualtat:
        static public bool operator ==(Angles obj1, Angles obj2)
        {
            bool iguals;

            iguals = (obj1.comparaAngle(obj1, obj2) == 0) ? true : false;

            return iguals;
        }

        //Sobrecriu l'operador de comparacio de desigualtat:
        static public bool operator !=(Angles obj1, Angles obj2)
        {
            bool desiguals = !(obj1 == obj2);
            return desiguals;
        }

        //Sobrecriu l'operador de comparacio menor que:
        static public bool operator <(Angles obj1, Angles obj2)
        {
            bool menorPrimer;

            menorPrimer = (obj1.comparaAngle(obj1, obj2) == -1) ? true : false;

            return menorPrimer;
        }

        //Sobrecriu l'operador de comparacio major que:
        static public bool operator >(Angles obj1, Angles obj2)
        {
            bool majorPrimer;

            majorPrimer = (obj1.comparaAngle(obj1, obj2) == 1) ? true : false;

            return majorPrimer;
        }

        //Indexador per a les seves propietats:
        public int this[int num]
        {
            get
            {
                //En lloc d'un error, farem que el num doni "la volta":
                num %= 3;

                int valor;

                switch (num)
                {
                    case 0:
                        valor = this.getGraus();
                        break;
                    case 1:
                        valor = this.getMinuts();
                        break;
                    case 2:
                        valor = this.getSegons();
                        break;
                    default:
                        valor = -1; //Cas impossible tenint en compte que hem fet un modul adalt.
                        break;
                }

                return valor;
            }
        }

        //Propietat amb get i set per als graus (es lo mateix que angle):
        public int Angle
        {
            get { return this.Graus; }
            set { this.Graus = value; }
        }
        public int Graus
        {
            get
            {
                return this.getGraus();
            }
            set
            {
                if (value.GetType().ToString() == "System.Int32") //(value.GetType() == TypeOf(0))
                {
                    this.setGraus(value);
                }
                else
                {
                    Console.WriteLine("Solament es poden assignar Integers de 32 bit als graus (angle)!");
                }
            }
        }
        
        //Propietat amb get i set per als minuts:
        public int Minuts
        {
            get
            {
                return this.getMinuts();
            }
            set
            {
                if (value.GetType().ToString() == "System.Int32") //(value.GetType() == TypeOf(0))
                {
                    this.setMinuts(value);
                }
                else
                {
                    Console.WriteLine("Solament es poden assignar Integers de 32 bit als minuts!");
                }
            }
        }

        //Propietat amb get i set per als segons:
        public int Segons
        {
            get
            {
                return this.getSegons();
            }
            set
            {
                if (value.GetType().ToString() == "System.Int32") //(value.GetType() == TypeOf(0))
                {
                    this.setSegons(value);
                }
                else
                {
                    Console.WriteLine("Solament es poden assignar Integers de 32 bit als segons!");
                }
            }
        }

        public void setAngle(int angle) { this.setGraus(angle); } //Fa lo mateix que setGraus().

        public void setGraus(int graus)
        {
            //En lloc d'un error, si es passen mes de 359 graus els passem a la mesura correcta:
            graus = graus % 360;

            this.angle = graus;
        }

        public int getAngle() { return this.getGraus(); } //Fa lo mateix que getGraus().

        public int getGraus()
        {
            return this.angle;
        }

        public void setMinuts(int minuts)
        {
            //En lloc d'un error, si ens passen mes de 59 minuts passem el possible a graus:
            int minutsReals = minuts % 60;
            int graus = minuts / 60;
            this.minut = minutsReals;
            this.setGraus(this.getGraus() + graus);
        }

        public int getMinuts()
        {
            return this.minut;
        }

        public void setSegons(int segons)
        {
            //En lloc d'un error, si ens passen mes de 59 segons passem el possible a minuts:
            int segonsReals = segons % 60;
            int minuts = segons / 60;
            this.segon = segonsReals;
            this.setMinuts(this.getMinuts() + minuts);
        }

        public int getSegons()
        {
            return this.segon;
        }

        public int comparaAngles(int angle) { return this.comparaGraus(angle); } //Fa lo mateix que comparaGraus() amb un parametre enter.

        public int comparaAngles(int angle1, int angle2) { return this.comparaGraus(angle1, angle2); } //Fa lo mateix que comparaGraus() amb dos parametres enters.

        public int comparaGraus(int graus) { return this.comparaGraus(this.getGraus(), graus); } //Compara els graus propis amb un passat per parametre.

        //Retorna si els graus son iguals (0), menor el primer (-1) o major el primer (1):
        public int comparaGraus(int graus1, int graus2)
        {
            int valor;
            if (graus1 == graus2) { valor = 0; }
            else if (graus1 < graus2) { valor = 1; }
            else { valor = 1; }
            return valor;
        }

        public int comparaMinuts(int minuts) { return this.comparaMinuts(this.getMinuts(), minuts); } //Compara els minuts propis amb un passat per parametre.

        //Retorna si els minuts son iguals (0), menor el primer (-1) o major el primer (1):
        public int comparaMinuts(int minuts1, int minuts2) //Nota: es podria haber utilitzat comparaGraus() ja que fan lo mateix, pero ho deixo separat per si fos diferent (bastant estrany).
        {
            int valor;
            if (minuts1 == minuts2) { valor = 0; }
            else if (minuts1 < minuts2) { valor = 1; }
            else { valor = 1; }
            return valor;
        }

        public int comparaSegons(int segons) { return this.comparaSegons(this.getSegons(), segons); } //Compara els segons propis amb un passat per parametre.

        //Retorna si els segons son iguals (0), menor el primer (-1) o major el primer (1):
        public int comparaSegons(int segons1, int segons2) //Nota: es podria haber utilitzat comparaGraus() ja que fan lo mateix, pero ho deixo separat per si fos diferent (bastant estrany).
        {
            int valor;
            if (segons1 == segons2) { valor = 0; }
            else if (segons1 < segons2) { valor = 1; }
            else { valor = 1; }
            return valor;
        }

        //Compara l'objecte propi amb un objecte passat per parametre:
        public int comparaAngle(Angles obj) //Nota: Pel nom crea confusio amb comparaAngles(), pero admiteix diferents parametres i no se m'ocurria cap millor.
        {
            return this.comparaAngle(this, obj);
        }

        //Compara dos objectes:
        public int comparaAngle(Angles obj1, Angles obj2) //Nota: Pel nom crea confusio amb comparaAngles(), pero admiteix diferents parametres i no se m'ocurria cap millor.
        {
            return this.comparaAngle(obj1.getGraus(), obj1.getMinuts(), obj1.getSegons(), obj2.getGraus(), obj2.getMinuts(), obj2.getSegons());
        }

        //Compara els atributs propis amb els passats per parametre:
        public int comparaAngle(int graus, int minuts, int segons)
        {
            return this.comparaAngle(this.getGraus(), this.getMinuts(), this.getSegons(), graus, minuts, segons);
        }

        //Retorna si el angle passat es igual (0), menor el primer (-1) o major el primer (1):
        public int comparaAngle(int graus1, int minuts1, int segons1, int graus2, int minuts2, int segons2) //Nota: Pel nom crea confusio amb comparaAngles(), pero admiteix diferents parametres i no se m'ocurria cap millor.
        {
            int valor;
            
            int grausComparacio = this.comparaGraus(graus1, graus2);
            int minutsComparacio = this.comparaMinuts(minuts1, minuts2);
            int segonsComparacio = this.comparaSegons(segons1, segons2);

            if (grausComparacio == 0 && minutsComparacio == 0 && segonsComparacio == 0)
            {
                valor = 0; //Iguals.
            }
            else
            {
                if (grausComparacio == -1) { valor = -1; } //Mes petit el primer.
                else if (grausComparacio == 1) { valor = 1; } //Mes gran el primer.
                else
                {
                    if (minutsComparacio == -1) { valor = -1; } //Mes petit el primer.
                    else if (minutsComparacio == 1) { valor = 1; } //Mes gran el primer.
                    else
                    {
                        if (segonsComparacio == -1) { valor = -1; } //Mes petit el primer.
                        else { valor = 1; } //Mes gran el primer.
                    }
                }
            }

            return valor;
        }

        public override string ToString()
        {
            String cadena = this.getGraus() + " " + this.getMinuts() + "' " + this.getSegons() + "''";
            return cadena;
        }
    }
}
