using System;
using System.Collections.Generic;
using System.Text;

using System.Windows.Forms;
using System.Drawing;
using System.IO;

namespace WindowsApplication1
{
    class listaImagenes
    {
        protected ImageList imageList = null;
        protected uint imagenSeleccionadaIndice = 0;

        public listaImagenes(ImageList imageList)
        {
            this.imageList = imageList;
        }

        public void setImageList(ImageList imageList)
        {
            this.imageList = imageList;
        }

        public ImageList getImageList()
        {
            return this.imageList;
        }

        public uint getImagenSeleccionadaIndice()
        {
            return this.imagenSeleccionadaIndice;
        }

        public void setImagenSeleccionadaIndice(uint indice)
        {
            indice = (uint) (indice % this.imageList.Images.Count);
            this.imagenSeleccionadaIndice = indice;
        }

        public void avanzarImagen()
        {
            this.setImagenSeleccionadaIndice(this.getImagenSeleccionadaIndice() + 1);
        }

        public void retrocederImagen()
        {
            uint indice = this.getImagenSeleccionadaIndice() - 1;
            if (indice < 0) { indice = (uint) (this.imageList.Images.Count - 1); }
            this.setImagenSeleccionadaIndice(indice);
        }
 
        public void agregarImagen(String archivoImagen)
        {
            Bitmap imagen = new Bitmap(archivoImagen);
            this.imageList.Images.Add(imagen);
        }

        public void quitarImagen(String indice)
        {
            this.imageList.Images.RemoveByKey(indice);
        }

        public void vaciarLista()
        {
            this.imageList.Images.Clear();
        }

        public void cargarDirectorioImagenes(String extension)
        {
            if (!Directory.Exists(Application.StartupPath + "\\img")) { return; }
            
            string[] imagenes = Directory.GetFiles(Application.StartupPath, "img\\*." + extension);
            foreach (string archivoImagen in imagenes)
            {
                Bitmap imagen = new Bitmap(archivoImagen);
                this.agregarImagen(archivoImagen);
            }
        }

        public void cargarDirectorioImagenes()
        {
            this.cargarDirectorioImagenes("jpg");
            this.cargarDirectorioImagenes("jpeg");
            this.cargarDirectorioImagenes("gif");
            this.cargarDirectorioImagenes("bmp");
        }

        public void mostrarLista(Graphics g)
        {
            int width = this.imageList.ImageSize.Width;
            int height = this.imageList.ImageSize.Height;
            int margen = 10, left, top;
            int imagenesPorColumna = 2;
            int imagenesPuestas = 0;
            for (int y = 0; y < this.imageList.Images.Count / imagenesPorColumna; y++)
            {
                for (int x = 0; x < imagenesPorColumna; x++)
                {
                    if (imagenesPuestas < this.imageList.Images.Count)
                    {
                        left = (x + 1) * (width + margen);
                        top = (y + 1) * (height + margen);
                        if (imagenesPuestas == this.getImagenSeleccionadaIndice()) { this.mostrarSeleccion(g, left, top, margen); }
                        this.imageList.Draw(g, left, top, imagenesPuestas++);
                    }
                }
            }
        }

        public void mostrarSeleccion(Graphics g, int left, int top, int margen)
        {
            //Pen pen = new Pen(Color.FromArgb(255, 0, 0));
            margen = margen / 2;
            Brush brush = new SolidBrush(Color.FromArgb(255, 0, 0));
            g.FillRectangle(brush, left - margen / 2, top - margen/2, this.imageList.ImageSize.Width + (margen/2*2), this.imageList.ImageSize.Height + (margen/2*2));
        }
    }
}
