using System;
using System.Collections.Generic;
using System.Text;

using System.Windows.Forms;
using System.Collections;
using System.Drawing;
using System.IO;

namespace WindowsApplication1
{
    class listaImagenes
    {
        protected ImageList imageList = null;
        protected ArrayList imagenes = new ArrayList();

        protected uint imagenSeleccionadaIndice = 0;
        protected PictureBox pictureBox = null;

        public listaImagenes(ImageList imageList)
        {
            this.imageList = imageList;
        }

        public void setImageList(ImageList imageList)
        {
            this.imageList = imageList;
        }

        public ImageList getImageList()
        {
            return this.imageList;
        }

        public void setPictureBox(PictureBox pictureBox, bool stretch)
        {
            this.pictureBox = pictureBox;
            this.stretchPictureBox(stretch);
        }

        public PictureBox getPictureBox()
        {
            return this.pictureBox;
        }

        public uint getImagenSeleccionadaIndice()
        {
            return this.imagenSeleccionadaIndice;
        }

        public void setImagenSeleccionadaIndice(uint indice)
        {
            indice = (uint) (indice % this.imageList.Images.Count);
            this.imagenSeleccionadaIndice = indice;
            this.representarImagen(this.getImagenSeleccionadaIndice());
        }

        public void avanzarImagen()
        {
            this.setImagenSeleccionadaIndice((uint) (this.getImagenSeleccionadaIndice() + 1));
        }

        public void retrocederImagen()
        {
            int indice = (int) this.getImagenSeleccionadaIndice() - 1;
            if (indice < 0) { indice = (this.imageList.Images.Count - 1); }
            this.setImagenSeleccionadaIndice((uint)indice);
        }
 
        public void agregarImagen(String archivoImagen)
        {
            Bitmap imagen = new Bitmap(archivoImagen);
            this.imageList.Images.Add(imagen);
            this.imagenes.Add(archivoImagen);
        }

        public void quitarImagen(string indice)
        {
            this.imageList.Images.RemoveByKey(indice);
            this.imagenes.RemoveAt(Int32.Parse(indice));
        }

        public void vaciarLista()
        {
            this.imageList.Images.Clear();
        }

        public void cargarDirectorioImagenes(String extension)
        {
            if (!Directory.Exists(Application.StartupPath + "\\img")) { return; }
            
            string[] imagenes = Directory.GetFiles(Application.StartupPath, "img\\*." + extension);
            foreach (string archivoImagen in imagenes)
            {
                Bitmap imagen = new Bitmap(archivoImagen);
                this.agregarImagen(archivoImagen);
            }
        }

        public void cargarDirectorioImagenes()
        {
            this.cargarDirectorioImagenes("jpg");
            this.cargarDirectorioImagenes("jpeg");
            this.cargarDirectorioImagenes("gif");
            this.cargarDirectorioImagenes("bmp");
        }

        public void mostrarLista(Graphics g)
        {
            int width = this.imageList.ImageSize.Width;
            int height = this.imageList.ImageSize.Height;
            int margen = 10, left, top;
            int imagenesPorColumna = 10;
            int imagenesPuestas = 0;
            for (int y = 0; y < (this.imageList.Images.Count + 0.5 / imagenesPorColumna); y++)
            {
                for (int x = 0; x < imagenesPorColumna; x++)
                {
                    if (imagenesPuestas < this.imageList.Images.Count)
                    {
                        left = (x + 1) * (width + margen);
                        top = (y + 1) * (height + margen);
                        if (imagenesPuestas == this.getImagenSeleccionadaIndice()) { this.mostrarSeleccion(g, left, top, margen); }
                        else { this.mostrarNoSeleccion(g, left, top, margen); }
                        this.imageList.Draw(g, left, top, imagenesPuestas++);
                    }
                }
            }
            this.representarImagen(this.getImagenSeleccionadaIndice());
        }

        public void mostrarSeleccion(Graphics g, int left, int top, int margen)
        {
            Brush brush = new SolidBrush(Color.FromArgb(255, 0, 0));
            this.mostrarMarco(g, left, top, margen, brush);
        }

        public void mostrarNoSeleccion(Graphics g, int left, int top, int margen)
        {
            Brush brush = new SolidBrush(Color.FromArgb(0, 0, 0));
            this.mostrarMarco(g, left, top, margen, brush);
        }

        public void mostrarMarco(Graphics g, int left, int top, int margen, Brush brush)
        {
            margen = margen / 2;
            g.FillRectangle(brush, left - margen / 2, top - margen / 2, this.imageList.ImageSize.Width + (margen / 2 * 2), this.imageList.ImageSize.Height + (margen / 2 * 2));
        }

        public void representarImagen(uint imagenIndice)
        {
            if (this.getPictureBox() == null) { return; }

            this.pictureBox.Image = new Bitmap((string) this.imagenes[(int)imagenIndice]);
        }

        public void stretchPictureBox(bool stretch)
        {
            if (stretch)
            {
                this.pictureBox.SizeMode = PictureBoxSizeMode.StretchImage;
            }
            else
            {
                //this.pictureBox.SizeMode = PictureBoxSizeMode.Normal;
                //this.pictureBox.Size.Width = ((Bitmap)this.imagenes[(int)this.getImagenSeleccionadaIndice()]).Width;
                //this.pictureBox.Size.Height = ((Bitmap)this.imagenes[(int)this.getImagenSeleccionadaIndice()]).Height;
                this.pictureBox.SizeMode = PictureBoxSizeMode.AutoSize;
            }
            this.pictureBox.Left = 0;
            this.pictureBox.Top = 0;
        }
    }
}
