using System;
using System.Collections.Generic;
using System.Text;

using System.Windows.Forms;
using System.Collections;
using System.Drawing;
using System.IO;

namespace WindowsApplication1
{
    class listaImagenes
    {
        //ImageList con las imagenes en miniatura:
        protected ImageList imageList = null;
        
        //Lista de las imagenes existentes:
        protected ArrayList imagenes = new ArrayList();

        //Indice de la imagen seleccionada:
        protected uint imagenSeleccionadaIndice = 0;
        
        //Picturebox donde se muestra la imagen seleccionada:
        protected PictureBox pictureBox = null;

        
        //Constructor:
        public listaImagenes(ImageList imageList)
        {
            this.imageList = imageList;
        }

        public void setImageList(ImageList imageList)
        {
            this.imageList = imageList;
        }

        public ImageList getImageList()
        {
            return this.imageList;
        }

        public void setPictureBox(PictureBox pictureBox, bool stretch)
        {
            this.pictureBox = pictureBox;
            this.stretchPictureBox(stretch);
        }

        public PictureBox getPictureBox()
        {
            return this.pictureBox;
        }

        //Devuelve el indice de la imagen seleccionada:
        public uint getImagenSeleccionadaIndice()
        {
            return this.imagenSeleccionadaIndice;
        }

        //Define el indice de la imagen seleccionada (selecciona una imagen):
        public void setImagenSeleccionadaIndice(uint indice)
        {
            if (this.imageList.Images.Count > 0) { indice = (uint)(indice % this.imageList.Images.Count); }
            else { indice = 0; }
            this.imagenSeleccionadaIndice = indice;
            this.representarImagen(this.getImagenSeleccionadaIndice());
        }

        //Avanza una imagen (si supera el final, vuelve a comenzar):
        public void avanzarImagen()
        {
            this.setImagenSeleccionadaIndice((uint) (this.getImagenSeleccionadaIndice() + 1));
        }

        //Retrocede una imagen (si es menor que 0, aparece por el final):
        public void retrocederImagen()
        {
            int indice = (int) this.getImagenSeleccionadaIndice() - 1;
            if (indice < 0) { indice = (this.imageList.Images.Count - 1); }
            this.setImagenSeleccionadaIndice((uint)indice);
        }
 
        //Agrega una imagen, situandola en el ultimo indice:
        public void agregarImagen(String archivoImagen)
        {
            Bitmap imagen = new Bitmap(archivoImagen);
            this.imageList.Images.Add(imagen);
            this.imagenes.Add(archivoImagen);
        }

        //Borra una imagen, dado su indice:
        public void quitarImagen(string indice)
        {
            this.imageList.Images.RemoveByKey(indice);
            this.imagenes.RemoveAt(Int32.Parse(indice));
        }

        //Quita todas las imagenes:
        public void vaciarLista()
        {
            this.imageList.Images.Clear();
            this.imagenes.Clear();
        }

        //Lee el directorio de imagenes y carga las imagenes con la extension dada:
        public uint cargarDirectorioImagenes(String extension)
        {
            if (!Directory.Exists(Application.StartupPath + "\\img")) { return 0; }

            uint imagenesPuestas = 0;

            string[] imagenes = Directory.GetFiles(Application.StartupPath, "img\\*." + extension);
            foreach (string archivoImagen in imagenes)
            {
                Bitmap imagen = new Bitmap(archivoImagen);
                this.agregarImagen(archivoImagen);
                imagenesPuestas++;
            }

            return imagenesPuestas;
        }

        //Lee el directorio de imagenes y carga las imagenes con varias extensiones:
        public uint cargarDirectorioImagenes()
        {
            this.vaciarLista();

            uint imagenesPuestas = this.cargarDirectorioImagenes("jpg");
            imagenesPuestas += this.cargarDirectorioImagenes("jpeg");
            imagenesPuestas += this.cargarDirectorioImagenes("gif");
            imagenesPuestas += this.cargarDirectorioImagenes("bmp");
            return imagenesPuestas;
        }

        //Muestra la lista de las imagenes:
        public void mostrarLista(Graphics g)
        {
            int width = this.imageList.ImageSize.Width;
            int height = this.imageList.ImageSize.Height;
            int margen = 10, left, top;
            int imagenesPorColumna = 10;
            int imagenesPuestas = 0;
            for (int y = 0; y < (this.imageList.Images.Count + 0.5 / imagenesPorColumna); y++)
            {
                for (int x = 0; x < imagenesPorColumna; x++)
                {
                    if (imagenesPuestas < this.imageList.Images.Count)
                    {
                        left = (x + 1) * (width + margen);
                        top = (y + 1) * (height + margen);
                        if (imagenesPuestas == this.getImagenSeleccionadaIndice()) { this.mostrarSeleccion(g, left, top, margen); }
                        else { this.mostrarNoSeleccion(g, left, top, margen); }
                        this.imageList.Draw(g, left, top, imagenesPuestas++);
                    }
                }
            }
            this.representarImagen(this.getImagenSeleccionadaIndice());
        }

        //Marca la imagen seleccionada actualmente:
        public void mostrarSeleccion(Graphics g, int left, int top, int margen)
        {
            Brush brush = new SolidBrush(Color.FromArgb(255, 0, 0));
            this.mostrarMarco(g, left, top, margen, brush);
        }

        //Marca la imagen que no esta seleccionada:
        public void mostrarNoSeleccion(Graphics g, int left, int top, int margen)
        {
            Brush brush = new SolidBrush(Color.FromArgb(0, 0, 0));
            this.mostrarMarco(g, left, top, margen, brush);
        }

        //Muestra un marco de seleccion o de no-seleccion:
        public void mostrarMarco(Graphics g, int left, int top, int margen, Brush brush)
        {
            margen = margen / 2;
            g.FillRectangle(brush, left - margen / 2, top - margen / 2, this.imageList.ImageSize.Width + (margen / 2 * 2), this.imageList.ImageSize.Height + (margen / 2 * 2));
        }

        //Pone la imagen que tiene el indice enviado en el PictureBox:
        public void representarImagen(uint imagenIndice)
        {
            if (this.getPictureBox() == null) { return; }
            
            if (this.imageList.Images.Count <= 0) { return; }

            this.pictureBox.Image = new Bitmap((string) this.imagenes[(int)imagenIndice]);
        }

        //Pone o quita el stretch al PictureBox que muestra la imagen seleccionada:
        public void stretchPictureBox(bool stretch)
        {
            if (stretch)
            {
                this.pictureBox.SizeMode = PictureBoxSizeMode.StretchImage;
            }
            else
            {
                this.pictureBox.SizeMode = PictureBoxSizeMode.AutoSize;
            }
        }
    }
}
