using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using FormPrincipalNamespace;

using MySql.Data.MySqlClient;
using MySql.Data.Types;


namespace GestioMassivaNamespace
{
    public partial class GestioMassiva : Form
    {
        public GestioMassiva()
        {
            InitializeComponent();
        }

        //Muestra los usuarios devueltos por una consulta en el label correspondiente:
        private void mostrarUsuariosNormales()
        {
            int usuariosNormales = 0;

            //Define la instruccion:
            String instruccion = "SELECT ID, Nombre, 1_Apellido, 2_Apellido FROM personas";

            try
            {
                //Ejecuta la instruccion:
                //if (FormPrincipal.baseDatos.getDataReader() != null) { FormPrincipal.baseDatos.getDataReader().Close(); }
                DataSet dataSet = FormPrincipal.baseDatos.consultaDataSet(instruccion);
                if (dataSet != null) { usuariosNormales = dataSet.Tables[0].Rows.Count; }
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }

            //Define el label con los valores obtenidos:
            this.usuarisLabel.Text = "Personas normales: " + usuariosNormales;
        }

        //Realiza las funciones correspondientes al iniciar este formulario:
        private void GestioMassiva_Load(object sender, EventArgs e)
        {
            //Muestra los usuarios en el label:
            mostrarUsuariosNormales();

            //Define la instruccion:
            String instruccion = "SELECT ID, Nombre, 1_Apellido, 2_Apellido FROM personas";
            //String instruccion = "SELECT * FROM personas";

            DataSet dataSet = null;

            try
            {
                //Ejecuta la instruccion:
                dataSet = FormPrincipal.baseDatos.consultaDataSet(instruccion);
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }

            if (dataSet != null)
            {
                try
                {
                    //Rellena el DataGridView con el DataSet obtenido:
                    this.GestioMassivaDataGridView.DataSource = dataSet.Tables[0];
                }
                catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }
            }

            /*try
            {
                MySqlCommandBuilder cb = new MySqlCommandBuilder(FormPrincipal.baseDatos.dataAdapter);
                FormPrincipal.baseDatos.dataAdapter.InsertCommand = cb.GetInsertCommand();
                FormPrincipal.baseDatos.getDataSet().AcceptChanges();
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }*/
        }

        //Metodo que guarda las modificaciones efectuadas en el DataGridView:
        private void guardaButton_Click(object sender, EventArgs e)
        {
            try
            {
                /*
                MySqlCommand comandoUpdate = new MySqlCommand(
                                "UPDATE personas SET Nombre = @nombre, 1_Apellido = @1_apellido, 2_Apellido = @2_apellido " +
                                "WHERE ID = @id",
                                FormPrincipal.baseDatos.getDataConnection());
                comandoUpdate.Parameters.Add("@nombre", MySqlDbType.VarChar, 125, "Nombre");
                comandoUpdate.Parameters.Add("@1_apellido", MySqlDbType.VarChar, 125, "1_Apellido");
                comandoUpdate.Parameters.Add("@2_apellido", MySqlDbType.VarChar, 125, "2_apellido");
                comandoUpdate.Parameters.Add("@id", MySqlDbType.Int64, 40, "ID");
                
                MySqlParameter parameter = comandoUpdate.Parameters.Add(
                    "@oldID", MySqlDbType.Int64, 40, "ID");
                
                parameter.SourceVersion = DataRowVersion.Original;

                FormPrincipal.baseDatos.dataAdapter.UpdateCommand = comandoUpdate;
                */

                //FormPrincipal.baseDatos.dataAdapter.ContinueUpdateOnError = true;
                
                //Se obtiene un comando de actualizacion y se asocia al DataAdapter:
                MySqlCommandBuilder cb = new MySqlCommandBuilder(FormPrincipal.baseDatos.dataAdapter);
                FormPrincipal.baseDatos.dataAdapter.UpdateCommand = cb.GetUpdateCommand();

                //Se efectua la actualizacion del DataAdapter:
                FormPrincipal.baseDatos.dataAdapter.Update(FormPrincipal.baseDatos.getDataSet(), "miDataSet");

                //this.GestioMassivaDataGridView.Update();

                //Define que el DataSet acepte los cambios que se le envien:
                FormPrincipal.baseDatos.getDataSet().AcceptChanges();

                //FormPrincipal.baseDatos.dataAdapter.AcceptChangesDuringUpdate = true;

            }
            catch (DBConcurrencyException ex) { MessageBox.Show("Excepcio: " + ex.Message + "\nColumna que ha dado el error tiene el valor = " + ex.Row[0].ToString()); }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }
            
            //Vuelve a mostrar los usuarios en el label (por si hay uno mas):
            mostrarUsuariosNormales();
        }
    }
}