using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using FormPrincipalNamespace;

using MySql.Data.MySqlClient;
using MySql.Data.Types;


namespace PrestecsNamespace
{
    public partial class Prestecs : Form
    {
        public int accio; //Define si va a ser un formulario de Passar prestec o de Anullar reserva.

        //Constructor que define las caracteristicas del formulario segun el tipo enviado:
        public Prestecs(int accio)
        {
            InitializeComponent();
            String botoText = (accio == 0) ? "Passar a prstec" : "Anullar reserva";
            String titol = botoText;
            this.prestecButton.Text = botoText;
            this.Text = titol;
            this.accio = accio;
        }

        //Efectua lo pertinente al hacer click en el boton:
        private void prestecButton_Click(object sender, EventArgs e)
        {
            if (this.accio == 0)
            {
                this.passarPrestec();
            }
            else
            {
                this.esborraPrestec();
            }
        }

        //Metodo que pasa una reserva de un libro que tiene un usuario a prestamo:
        private void passarPrestec()
        {
            //Si el DataGridView esta vacio o no hay nada seleccionado, sale de la funcion:
            if (this.prestecDataGridView == null || this.prestecDataGridView.SelectedCells.Count <= 0 || this.prestecDataGridView.SelectedCells[0] == null) { MessageBox.Show("No s'han selleccionat registres"); return; }

            String nomUsuari = (String)this.prestecListBox.SelectedItem; //Nombre de usuario seleccionado en el ListBox.
            String llibreISBN = this.prestecDataGridView.SelectedCells[0].Value.ToString(); //Primera fila seleccionada en el DataGridView.

            //String instruccion = "INSERT INTO prestamos (id_usuario, id_material, fecha_inicio, fecha_fin) VALUES (personas.ID, material.ID, 'sin_fecha', 'sin_fecha') WHERE EXISTS (SELECT * FROM personas, material ON personas.nombre LIKE '" + nomUsuari + "' AND material.ISBN LIKE '" + llibreISBN + "')";
            String instruccion = "INSERT INTO prestamos (id_usuario, id_material) SELECT personas.id, material.id FROM personas JOIN material ON personas.nombre LIKE '" + nomUsuari + "' AND material.ISBN LIKE '" + llibreISBN + "'";

            int columnesAfectades = 0;

            try
            {
                columnesAfectades = FormPrincipal.baseDatos.modificacion(instruccion);
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }

            if (columnesAfectades > 0)
            {
                MessageBox.Show("Llibre amb ISBN " + llibreISBN + " passat a prestec per a " + nomUsuari);
            }
            else
            {
                MessageBox.Show("El llibre amb ISBN " + llibreISBN + " no s'ha pogut passar a prestec per a " + nomUsuari + " (pot ser que ja el tingui en prestec)");
            }
        }

        //Metodo que borra el prestamo de un libro que tiene un usuario:
        private void esborraPrestec()
        {
            //Si el DataGridView esta vacio o no hay nada seleccionado, sale de la funcion:
            if (this.prestecDataGridView == null || this.prestecDataGridView.SelectedCells.Count <= 0 || this.prestecDataGridView.SelectedCells[0] == null) { MessageBox.Show("No s'han selleccionat registres"); return; }

            String nomUsuari = (String) this.prestecListBox.SelectedItem; //Nombre de usuario seleccionado en el ListBox.
            String llibreISBN = this.prestecDataGridView.SelectedCells[0].Value.ToString(); //Primera fila seleccionada en el DataGridView.

            String instruccion = "DELETE prestamos FROM prestamos JOIN personas JOIN material ON personas.ID = prestamos.id_usuario AND material.ID = prestamos.id_material WHERE personas.nombre LIKE '" + nomUsuari + "' AND material.ISBN LIKE '" + llibreISBN + "'";

            int columnesAfectades = 0;

            try
            {
                columnesAfectades = FormPrincipal.baseDatos.modificacion(instruccion);
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }

            if (columnesAfectades > 0)
            {
                MessageBox.Show("Llibre amb ISBN " + llibreISBN + " esborrat per a " + nomUsuari);
            }
            else
            {
                MessageBox.Show("El llibre amb ISBN " + llibreISBN + " no s'ha pogut esborrar per a " + nomUsuari + " (pot ser que ja no el tingui en prestec)");
            }
        }

        //Metodo que se ejecuta al cargar el formulario:
        private void Prestecs_Load(object sender, EventArgs e)
        {
            //Carga los usuarios en el ListBox:
            this.carregaUsuaris();
        }

        //Metodo que carga todos los usuarios existentes en el ListBox:
        private void carregaUsuaris()
        {
            String nomUsuari = "";

            String instruccion = "SELECT Nombre FROM personas";

            MySqlDataReader dataReader = null;

            try
            {
                //if (FormPrincipal.baseDatos.getDataReader() != null) { FormPrincipal.baseDatos.getDataReader().Close(); }

                dataReader = FormPrincipal.baseDatos.consulta(instruccion);
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }

            //Recorre el DataReader:
            if (dataReader != null && dataReader.HasRows)
            {
                while (dataReader.Read())
                {
                    nomUsuari = dataReader.GetString(0);
                    this.prestecListBox.Items.Add(nomUsuari); //Agrega al ListBox el usuario.
                }
            }
        }

        //Metodo que carga los libros que tiene en reserva un usuario:
        private void carregaLlibresUsuari(String nomUsuari)
        {
            String instruccion = "SELECT ISBN, Titulo FROM reservas JOIN personas JOIN material ON personas.ID = reservas.id_usuario AND material.ID = reservas.id_material WHERE personas.nombre LIKE '" + nomUsuari + "'";
            //String instruccion = "SELECT ISBN, Titulo FROM material";

            DataSet dataSet = null;

            try
            {
                dataSet = FormPrincipal.baseDatos.consultaDataSet(instruccion);
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }

            if (dataSet != null)
            {
                try
                {
                    this.prestecDataGridView.DataSource = dataSet.Tables[0];
                }
                catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }
            }
        }

        private void prestecListBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            
            carregaLlibresUsuari((String) this.prestecListBox.SelectedItem);
        }

    }
}