using System;
using System.Collections.Generic;
using System.Text;

using System.Windows.Forms;

using MySql.Data.MySqlClient;
using MySql.Data.Types;

using System.Data;

namespace controlDataGrid
{
    public class BD
    {
        protected String usuario;
        protected String clave;
        protected String host;
        protected String baseDatos;

        protected bool conectado = false;

        protected MySqlConnection dataConnection = null;
        protected MySqlDataReader dataReader = null;

        public MySqlDataAdapter dataAdapter = null;
        protected DataSet dataSet = null;

        protected Int64 scalar = -1;

        public BD()
        {
        }

        public BD(String usuario, String clave, String host, String baseDatos)
        {
            this.setUsuario(usuario);
            this.setClave(clave);
            this.setHost(host);
            this.setBaseDatos(baseDatos);
        }

        public void setUsuario(String usuario)
        {
            this.usuario = usuario;
        }

        public String getUsuario()
        {
            return this.usuario;
        }

        public void setClave(String clave)
        {
            this.clave = clave;
        }

        public String getClave()
        {
            return this.clave;
        }

        public void setHost(String host)
        {
            this.host = host;
        }

        public String getHost()
        {
            return this.host;
        }

        public void setBaseDatos(String baseDatos)
        {
            this.baseDatos = baseDatos;
        }

        public String getBaseDatos()
        {
            return this.baseDatos;
        }

        public void setDataConnection(MySqlConnection dataConnection)
        {
            this.dataConnection = dataConnection;
        }

        public MySqlConnection getDataConnection()
        {
            return this.dataConnection;
        }

        public void setDataReader(MySqlDataReader dataReader)
        {
            this.dataReader = dataReader;
        }

        public MySqlDataReader getDataReader()
        {
            return this.dataReader;
        }

        public void setDataSet(DataSet dataSet)
        {
            this.dataSet = dataSet;
        }

        public DataSet getDataSet()
        {
            return this.dataSet;
        }

        public void setScalar(Int64 scalar)
        {
            this.scalar = scalar;
        }

        public Int64 getScalar()
        {
            return this.scalar;
        }

        public bool getConectado()
        {
            return this.conectado;
        }

        public void conecta()
        {
            //Boolean totBe = true;

            if (this.getConectado()) { this.desconecta(); }
            this.setDataConnection(new MySqlConnection("datasource=" + host + ";database=" + baseDatos + ";uid=" + usuario + ";password=" + clave));
            this.getDataConnection().Open();

            this.conectado = true;

            //return totBe;
        }

        public bool desconecta()
        {
            Boolean totBe = true;

            if (!this.getConectado()) { return false; }

            if (this.getDataReader() != null) { this.getDataReader().Close(); }
            if (this.getDataConnection() != null) { this.getDataConnection().Close(); }

            return totBe;
        }

        public MySqlDataReader consulta(String instruccion)
        {
            if (!this.getConectado()) { return null; }

            //Ojo: a lo mejor asi no se comprueba si esta sin cerrar!!!
            if (this.getDataReader() != null) { this.getDataReader().Close(); }

            MySqlCommand dataCommand = new MySqlCommand();
            dataCommand.Connection = this.getDataConnection();
            dataCommand.CommandText = instruccion;

            this.setDataReader(dataCommand.ExecuteReader());

            return this.getDataReader();
        }

        public MySqlDataReader consultaDataReader(String instruccion)
        {
            return this.consulta(instruccion);
        }

        public Int64 consultaScalar(String instruccion)
        {
            if (!this.getConectado()) { return -1; }

            //Ojo: a lo mejor asi no se comprueba si esta sin cerrar!!!
            if (this.getDataReader() != null) { this.getDataReader().Close(); }

            MySqlCommand dataCommand = new MySqlCommand();
            dataCommand.Connection = this.getDataConnection();
            dataCommand.CommandText = instruccion;

            this.setScalar((Int64)dataCommand.ExecuteScalar());

            return this.getScalar();
        }

        public DataSet consultaDataSet(String instruccion)
        {
            if (!this.getConectado()) { return null; }

            //Ojo: a lo mejor asi no se comprueba si esta sin cerrar!!!
            if (this.getDataReader() != null) { this.getDataReader().Close(); }

            DataSet dataSet = new DataSet();
            MySqlDataAdapter dataAdapter = new MySqlDataAdapter(instruccion, this.getDataConnection());
            dataAdapter.Fill(dataSet, "miDataSet");

            this.dataAdapter = dataAdapter;

            this.setDataSet(dataSet);

            return dataSet;
        }

        public int modificacion(String instruccion)
        {
            int filasAfectadas = 0;

            if (!this.getConectado()) { return 0; }

            MySqlCommand dataCommand = new MySqlCommand();
            dataCommand.Connection = this.getDataConnection();
            dataCommand.CommandText = instruccion;
            filasAfectadas = dataCommand.ExecuteNonQuery();

            return filasAfectadas;
        }



        public String dataReaderToString(MySqlDataReader dataReader)
        {
            String campo;
            String cadena = "";
            //FALTA: poner nombre de columnas arriba, antes que los campos.
            while (dataReader != null && dataReader.Read())
            {
                campo = "";
                for (int x = 0; x < dataReader.FieldCount; x++) //Falta.
                {
                    campo = "[" + dataReader.GetString(x) + "]";
                    cadena += campo;
                }
                cadena += "\n";
            }
            return cadena;
        }

        public String toString()
        {
            return this.dataReaderToString(this.getDataReader());
        }
    }
}
