﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Xml;

using BaseDatos;

namespace ImportaXMLaDatagrid
{
    public partial class Form1 : Form
    {
        private BD baseDatos = new BD("root", "", "localhost", "biblioteca");

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            this.baseDatos.conecta();

            this.ompleDataGridAmbXML();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            this.baseDatos.desconecta();
        }

        private void ompleDataGridAmbXML()
        {
            /*
            //Manera 1: recorriendo XML:  
             
            XmlDocument doc = new XmlDocument();
            doc.Load("../../../../../biblioteca.xml");

            XmlNodeList ListaLibros = doc.SelectNodes("/Biblioteca/Libro");

            int nl = ListaLibros.Count;
            //MessageBox.Show("Numero total de libros = " + nl);

            int x = 0;
            this.myDataGridView.Columns.Add("Titulo", "Titulo");
            this.myDataGridView.Columns.Add("Autor", "Autor");
            foreach (XmlNode libro in ListaLibros)
            {
                this.myDataGridView.Rows.Add();
                this.myDataGridView[0, x].Value = libro.SelectSingleNode("Titulo").InnerText;
                this.myDataGridView[1, x].Value = libro.SelectSingleNode("Autor").InnerText;
                x++;
            }
            */

            //Manera 2: creando un DataSource y asociandolo:
            DataSet dataSet = new DataSet();
            dataSet.ReadXml("../../../../../biblioteca.xml");

            DataTableCollection tables = dataSet.Tables;
            DataView view1 = new DataView(tables[0]);

            //myDataGridView.AutoGenerateColumns = true;

            BindingSource source1 = new BindingSource();
            source1.DataSource = view1;

            myDataGridView.DataSource = source1;


            //Manera 3: manera mas rapido (NO FUNCIONA):
            /*
            DataSet dataSet = new DataSet();
            dataSet.ReadXml("../../../../../biblioteca.xml");
            this.myDataGridView.DataSource = dataSet;
            */
        }

    }
}