using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

using MySql.Data.MySqlClient;
using MySql.Data.Types;

namespace controlDataGrid
{
    
    public partial class controlDataGrid : UserControl
    {
        public BD baseDatos = null;
        public bool amagat = false;
        
        public controlDataGrid()
        {
            InitializeComponent();
        }

        public void conecta()
        {
            //Conecta a la base de dades:
            this.baseDatos = new BD("root", "", "localhost", "biblioteca");
            this.baseDatos.conecta();
        }

        public void desconecta()
        {
            //Desconecta a la base de dades:
            if (this.baseDatos != null) { this.baseDatos.desconecta(); }
        }

        public void restauraDataGridBackup()
        {
            this.myDataGrid.AllowSorting = true;
            this.myDataGrid.ReadOnly = false;
            this.myDataGrid.MouseUp -= new System.Windows.Forms.MouseEventHandler(this.myDataGrid_MouseUp_seleccionarFilera);
            this.amagat = false;
            this.ompleDataGrid();
            this.myDataGrid.MouseUp -= new System.Windows.Forms.MouseEventHandler(this.myDataGrid_Click_onEstas);
        }

        public void ompleDataGrid()
        {
            String instruccion = "SELECT ID, Nombre, 1_Apellido FROM personas";

            DataSet dataSet = null;

            try
            {
                dataSet = this.baseDatos.consultaDataSet(instruccion);
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }

            if (dataSet != null)
            {
                try
                {
                    this.myDataGrid.DataSource = dataSet.Tables[0];
                }
                catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }
            }
        }

        public void evitarOrdenacioColumnes()
        {
            //MessageBox.Show("Ordenacio Columnes");
            this.myDataGrid.AllowSorting = false;
        }

        public void evitarInsercioNovesFiles()
        {
            this.myDataGrid.ReadOnly = true;
        }

        public void seleccionarFilera()
        {
            this.myDataGrid.MouseUp += new System.Windows.Forms.MouseEventHandler(this.myDataGrid_MouseUp_seleccionarFilera);
        }

        private void myDataGrid_MouseUp_seleccionarFilera(object sender, MouseEventArgs e)
        {
            System.Drawing.Point pt = new Point(e.X, e.Y);
            DataGrid.HitTestInfo hti = this.myDataGrid.HitTest(pt);
            if (hti.Type == DataGrid.HitTestType.Cell)
            {
                this.myDataGrid.CurrentCell = new DataGridCell(hti.Row, hti.Column);
                this.myDataGrid.Select(hti.Row);
            }
        }

        public void amagarColumna()
        {
            this.amagat = true;

            String instruccion = "SELECT ID, Nombre, 1_Apellido FROM personas";

            DataSet dataSet = null;

            try
            {
                dataSet = this.baseDatos.consultaDataSet(instruccion);
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }

            if (dataSet != null)
            {
                try
                {
                    //this.myDataGrid.DataSource = dataSet.Tables[0];
                    dataSet.Tables[0].Columns[2].ColumnMapping = MappingType.Hidden;

                    this.myDataGrid.DataSource = dataSet.Tables[0];
                }
                catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }
            }
        }

        public int getAutoincrementMaxim()
        {
            int maximo = 0;

            String instruccion = "SELECT MAX(ID) FROM personas";
            MySqlDataReader myDataReader = this.baseDatos.consulta(instruccion);
            try
            {
                if (myDataReader != null && myDataReader.HasRows && myDataReader.Read())
                {
                    maximo = myDataReader.GetInt32(0);
                }
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }
            return maximo;

        }

        public void ompleDataGridAutocompletar(DataSet dataSet)
        {
            String instruccion = "SELECT ID FROM personas";
            
            int id, x = 0;

            int columna = 2;
            if (this.amagat) { columna = 1; }

            MySqlDataReader myDataReader = this.baseDatos.consulta(instruccion);
            try
            {
                if (myDataReader != null && myDataReader.HasRows)
                {
                    while (myDataReader.Read())
                    {
                        if (this.amagat) {  }
                        id = myDataReader.GetInt32(0);
                        this.myDataGrid[x, columna] = id;
                        x++;
                    }
                }
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }
        }

        public void autocompletar()
        {
            String instruccion = "SELECT Nombre, 1_Apellido FROM personas";
            if (this.amagat) { instruccion = "SELECT Nombre FROM personas"; }
            DataColumn ID = new DataColumn("ID", typeof(int));
            DataSet dataSet = null;
            
            ID.AutoIncrement = true;
            ID.AutoIncrementSeed = this.getAutoincrementMaxim();
            ID.AutoIncrementStep = 1;
           
            try
            {
                dataSet = this.baseDatos.consultaDataSet(instruccion);
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }

            if (dataSet != null)
            {
                try
                {
                    this.myDataGrid.DataSource = dataSet.Tables[0];
                    dataSet.Tables[0].Columns.Add(ID);
                    this.ompleDataGridAutocompletar(dataSet);
                }
                catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }
            }
        }

        public void onEstas()
        {
            this.myDataGrid.MouseUp += new System.Windows.Forms.MouseEventHandler(this.myDataGrid_Click_onEstas);
        }

        private void myDataGrid_Click_onEstas(object sender, MouseEventArgs e)
        {
            int columna = this.myDataGrid.CurrentCell.ColumnNumber;
            int fila = this.myDataGrid.CurrentCell.RowNumber;
            
            object valor = this.myDataGrid[fila, columna];

            MessageBox.Show("filera: " + fila + ", columna: " + columna + " => " + valor);
        }

        public void ompleDataGridDateTimerPicker()
        {
            String instruccion = "SELECT Fecha_Nacimiento FROM personas";

            String fecha;
            int x = 0;
            DateTimePicker elMeuDateTimePicker;

            MySqlDataReader myDataReader = this.baseDatos.consulta(instruccion);
            try
            {
                if (myDataReader != null && myDataReader.HasRows)
                {
                    while (myDataReader.Read())
                    {
                        fecha = myDataReader.GetString(0);

                        elMeuDateTimePicker = new DateTimePicker();
                        elMeuDateTimePicker.Value = DateTime.Parse(fecha);

                        //this.myDataGrid[x, 3] = elMeuDateTimePicker;
                        this.myDataGrid[x, 3] = elMeuDateTimePicker.Value;

                        x++;
                    }
                }
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }
        }

        public void columnaDateTimePicker()
        {

            String instruccion = "SELECT ID, Nombre, 1_Apellido, fecha_nacimiento FROM personas";
            if (this.amagat) { instruccion = "SELECT ID, Nombre, fecha_nacimiento FROM personas"; }
            DataSet dataSet = null;

            try
            {
                dataSet = this.baseDatos.consultaDataSet(instruccion);
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }

            if (dataSet != null)
            {
                try
                {
                    this.myDataGrid.DataSource = dataSet.Tables[0];
                    this.ompleDataGridDateTimerPicker();
                }
                catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }
            }
        }

        public void estils()
        {
            MessageBox.Show("8");
        }

        
        }

    }


