using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using dataGridPersonalitzatSpace;

using MainFormSpace;

using MySql.Data.MySqlClient;
using MySql.Data.Types;


namespace FormMatriculacioSpace
{
    public partial class FormMatriculacions : Form
    {
        public FormMatriculacions()
        {
            InitializeComponent();
        }

        //Metode que s'executa al fer click en el boto de sortir:
        private void botoSortir_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        //Metode que s'executa al fer click al boto de Gravar dades:
        private void botoGravarDades_Click(object sender, EventArgs e)
        {
            try
            {
                //Grava els canvis efectuats:
                //this.controlDataGrid1.dataGrid.Update();
                MainForm.baseDatos.dataAdapter.ContinueUpdateOnError = true;
                MainForm.baseDatos.dataAdapter.Update(MainForm.baseDatos.dataSet);
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }
        }

        //Metode que s'executa al iniciar aquest formulari:
        private void FormMatriculacions_Load(object sender, EventArgs e)
        {
            //Recollim el data grid personalitzat:
            dataGridPersonalitzat elMeuDataGrid = this.controlDataGrid1.dataGrid;

            //Li fiquem un titol:
            elMeuDataGrid.Titol = "Les matricules de l'IESBC";

            //Fem que es visualitzi el titol:
            elMeuDataGrid.VullTitol = true; //Per ocultar, ficar a false.

            //Apliquem el format que hem definit:
            elMeuDataGrid.format();

            //Omple el datagrid:
            this.omplirDataGrid();
        }

        protected void omplirDataGrid()
        {
            //Defineix l'instruccion:
            String instruccion = "SELECT nom_alu, edat, curs FROM alumnes ORDER BY num_matri";
            DataColumn num_matri = new DataColumn("num_matri", typeof(int));

            num_matri.AutoIncrement = true;
            num_matri.AutoIncrementSeed = this.getAutoincrementMaxim();
            num_matri.AutoIncrementStep = 1;

            DataSet dataSet = null;

            try
            {
                //Executa l'instruccion:
                dataSet = MainForm.baseDatos.consultaDataSet(instruccion);
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }

            if (dataSet != null)
            {
                try
                {
                    //Rellena el DataGridView con el DataSet obtenido:
                    this.controlDataGrid1.dataGrid.DataSource = dataSet.Tables[0];
                    dataSet.Tables[0].Columns.Add(num_matri);
                    this.ompleDataGridAutocompletar(dataSet);
                }
                catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }
            }
        }

        //Omple la columna que te l'autoincrement (num_matri):
        public void ompleDataGridAutocompletar(DataSet dataSet)
        {
            String instruccion = "SELECT num_matri FROM alumnes";

            int id, x = 0;

            int columna = 3;

            MySqlDataReader myDataReader = MainForm.baseDatos.consulta(instruccion);
            try
            {
                if (myDataReader != null && myDataReader.HasRows)
                {
                    while (myDataReader.Read())
                    {
                        id = myDataReader.GetInt32(0);
                        this.controlDataGrid1.dataGrid[x, columna] = id;
                        //this.myDataGrid[x, columna] = id;
                        x++;
                    }
                }
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }
        }

        //Retorna el numero mes alt de la columna amb autoincrement (num_matri):
        public int getAutoincrementMaxim()
        {
            int maximo = 0;

            String instruccion = "SELECT MAX(num_matri) FROM alumnes";
            MySqlDataReader myDataReader = MainForm.baseDatos.consulta(instruccion);
            try
            {
                if (myDataReader != null && myDataReader.HasRows && myDataReader.Read())
                {
                    maximo = myDataReader.GetInt32(0);
                }
            }
            catch (Exception ex) { MessageBox.Show("Excepcio: " + ex.Message); }
            return maximo;
        }
    }
}