﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsApplication1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            //Instancia la lista de imagenes:
            Program.crearListaImagenes();
            Program.milista.setPictureBox(this.pictureBox, false);
            
            //Muestra las imagenes: (comentado porque no funciona en el onLoad)
            //Graphics g = this.CreateGraphics();
            //Graphics g = Graphics.FromHwnd(this.Handle);
            //Program.milista.mostrarLista(g);
            //g.Dispose();
            
            //Agrega el picturebox dentro del panel:
            this.panel.Controls.Add(this.pictureBox);
        }

        //Funcion que representa la lista de imagenes:
        private void representarImagenes()
        {
            Graphics g = Graphics.FromHwnd(this.Handle);
            Program.milista.mostrarLista(g);
            g.Dispose();
        }

        //Carga el directorio de las imagenes y muestra la lista:
        private void button1_Click(object sender, EventArgs e)
        {
            //Carga el directorio de las imagenes:
            uint imagenes = Program.milista.cargarDirectorioImagenes();

            //Si hay imagenes, representa la lista de imagenes:
            if (imagenes > 0)
            {
                //Representa la lista:
                this.representarImagenes();
                
                //Activa los botones de avanzar y de retroceder:
                this.botonAvanzar.Enabled = true;
                this.botonRetroceder.Enabled = true;

                //Muestra un aviso de que las imagenes se han cargado:
                this.aviso.Text = "Las imágenes del directorio img han sido cargadas";
            }
            //...pero si no, muestra el aviso:
            else
            {
                //Desactiva los botones de avanzar y de retroceder:
                this.botonAvanzar.Enabled = false;
                this.botonRetroceder.Enabled = false;

                //Muestra un aviso de que no hay imagenes:
                this.aviso.Text = "No hay imágenes en el directorio img de la aplicación";
            }
        }

        private void botonRetroceder_Click(object sender, EventArgs e)
        {
            //Retrocede una imagen de la lista (selecciona la anterior):
            Program.milista.retrocederImagen();
            this.representarImagenes();
        }

        private void botonAvanzar_Click(object sender, EventArgs e)
        {
            //Avanza una imagen de la lista (selecciona la siguiente):
            Program.milista.avanzarImagen();
            this.representarImagenes();
        }

        //Funcion que hace stretch o lo quita en la imagen que estamos visualizando:
        private void stretch_CheckedChanged(object sender, EventArgs e)
        {
            //Quita o pone el stretch, segun corresponda:
            Program.milista.stretchPictureBox(this.stretch.Checked);

            //Si se ha realizado stretch:
            if (this.stretch.Checked)
            {
                //Se quita el autoscroll:
                this.panel.AutoScroll = false;
                
                //Se desplazan los scrollbars al final:
                this.panel.VerticalScroll.Value = this.panel.VerticalScroll.Maximum;
                this.panel.HorizontalScroll.Value = this.panel.HorizontalScroll.Maximum;
            }
            //...pero si no (si se ha quitado el stretch):
            else
            {
                //Se pone el autoscroll:
                this.panel.AutoScroll = true;

                //Se desplazan los scrollbars al principio:
                this.panel.VerticalScroll.Value = this.panel.VerticalScroll.Minimum;
                this.panel.HorizontalScroll.Value = this.panel.HorizontalScroll.Minimum;
            }

            //Se situa el picturebox alineado a la izquierda y arriba:
            this.pictureBox.Left = 0;
            this.pictureBox.Top = 0;
        }

        private void Form1_SizeChanged(object sender, EventArgs e)
        {
            this.representarImagenes();
        }

    }
}