﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ConsoleApplication1
{
    class Program
    {
        /*
         * NOTA: com el programa ja separa els arguments per espai, per ficar un 5 i un 9 ficarem "5 9"
         *       (sense cometes) i si volem 59 ficarem "59" (sense espais). Exemple: 5 9 + 2 + * 6 5 * +
         *       Aixi podrem treballar amb numeros mes grans de 10.
        */
        static void Main(string[] args)
        {
            //Si no s'envien parametres, dona error:
            if (args == null || args.Length <= 0) { Console.WriteLine("No hi ha arguments!"); Environment.Exit(0); } //Menor no podria ser mai, pero per si de cas.
            else if (!expressioValida(args)) { Console.WriteLine("Expressio invalida!"); Environment.Exit(0); }
            else //No fa falta el else perque els anteriors fan Exit().
            {
                double resultat = resoldre(args);
                Console.WriteLine("Resultat: " + resultat);
                Console.ReadKey();
            }
        }

        
        //Funcio que calcula si una expressio es valida o no (falta millorar):
        static bool expressioValida(string[] expressio)
        {
            bool valida = true;

            //Si hi han mes signes que numeros, es una expressio invalida:
            int signes = 0, numeros = 0;
            string termePulit;
            foreach (string terme in expressio)
            {
                termePulit = terme.Trim(); //Treiem espais al principi i al final.
                if (esSigne(termePulit)) { signes++; }
                else { numeros++; }
            }
            if (signes > numeros) { valida = false; }

            //FALTA: mirar mes coses que poden fer invalides les expressions.

            return valida;
        }

        
        //Funcio que retorna si un string es un signe operacional o no:
        static bool esSigne(string signe)
        { 
            string[] signes = { "+", "-", "*", "/" };
            //return (Array.Exists(signes, signe));
            return (existeix(signes, signe));
        }


        //Funcio que diu si un string existeix en una array de strings o no:
        static bool existeix(string[] matriu, string valor)
        {
            bool existeix = false;

            foreach (string v in matriu)
            {
                if (v.Trim() == valor.Trim()) { existeix = true; break; }
            }

            return existeix;
        }

        
        //Funcio que retorna el valor d'una expressio postfixa:
        static double resoldre(string[] expressio)
        {
            //Crea la pila on es desaran els numeros:
            PilaNumeros pila = new PilaNumeros();
            double a, b, resultat;
            string termePulit;

            foreach (string terme in expressio)
            {
                termePulit = terme.Trim();

                //Si el terme es un signe:
                if (esSigne(termePulit))
                {
                    //Treiem els dos operadors de la pila:
                    a = pila.extraerNumero();
                    b = pila.extraerNumero();

                    //Apliquem l'operacio que ens diu l'operador:
                    resultat = operacio(a, b, termePulit);

                    //Fiquem el nou resultat a la pila:
                    pila.agregarNumero(resultat);
                }
                //...pero si un numero, el fiquem a la pila:
                else
                {
                    pila.agregarNumero(termePulit);
                }
            }

            //Lo ultim que queda a la pila es el resultat final:
            return pila.extraerNumero();
        }


        //Funcio que fa una operacio amb dos numeros i un operant i retorna el resultat:
        static double operacio(double a, double b, string operant)
        {
            double resultat;
            switch (operant)
            {
                case "+":
                    resultat = a + b;
                    break;
                case "-":
                    resultat = a - b;
                    break;
                case "*":
                    resultat = a * b;
                    break;
                case "/":
                    resultat = a / b;
                    break;
                default:
                    resultat = 0;
                    break;
            }
            return resultat;
        }
    }
}
