﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsApplication1
{
    public partial class Form1 : Form
    {
        Poligon poligon = new Poligon();

        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            dibuixa();
            poligon.esborraPunts();
        }

        private void dibuixa()
        {
            //Si no hi ha punts per dibuixar, surt:
            if (poligon.punts.Count <= 0) { return; }

            //Recull el punt d'origen:
            double x0 = poligon.obtePunt(0).getX();
            double y0 = poligon.obtePunt(0).getY();

            double xOrigen, yOrigen, xDesti, yDesti;
            int posicioPuntSeguent = 1;

            //Dibuixa el poligon:
            Graphics gr = this.CreateGraphics();
            foreach (cspunt punt in poligon.punts)
            {
                xOrigen = punt.getX();
                yOrigen = punt.getY();
                if (posicioPuntSeguent >= poligon.punts.Count)
                {
                    xDesti = x0;
                    yDesti = y0;
                }
                else
                {
                    xDesti = poligon.obtePunt(posicioPuntSeguent).getX();
                    yDesti = poligon.obtePunt(posicioPuntSeguent).getY();
                }
                gr.DrawLine(new Pen(Color.Red), (float)xOrigen, (float)yOrigen, (float)xDesti, (float)yDesti);
                posicioPuntSeguent++;
            }
        }

        private void ferPunt(object sender, MouseEventArgs e)
        {
            double x = (double)e.X;
            double y = (double)e.Y;
            poligon.agregaPunt(x, y);
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }
    }
}