﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using BaseDatosNamespace;
using GestioIndividualNamespace;
using GestioMassivaNamespace;
using PrestecsNamespace;

using MySql.Data.MySqlClient;
using MySql.Data.Types;

namespace FormPrincipalNamespace
{
    public partial class FormPrincipal : Form
    {
        static public BD baseDatos = null; //Objeto manejador de base de datos.

        public FormPrincipal()
        {
            InitializeComponent();
        }

        //Abre el formulario de Gestio Individual (al hacer click en la opcion del menu):
        private void gestióIndividualToolStripMenuItem_Click(object sender, EventArgs e)
        {
            GestioIndividual childForm = new GestioIndividual();
            childForm.MdiParent = this;
            childForm.Show();
        }

        //Abre el formulario de Gestio Massiva (al hacer click en la opcion del menu):
        private void gestiómasivaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            GestioMassiva childForm = new GestioMassiva();
            childForm.MdiParent = this;
            childForm.Show();
        }

        //Abre el formulario de Passar a prestec (al hacer click en la opcion del menu):
        private void passarAPrestecToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Prestecs childForm = new Prestecs(0);
            childForm.MdiParent = this;
            childForm.Show();
        }

        //Abre el formulario d'Anul·lar reserva (al hacer click en la opcion del menu):
        private void anullarreservaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Prestecs childForm = new Prestecs(1);
            childForm.MdiParent = this;
            childForm.Show();
        }

        //La primera vez que inicia este form principal, conecta a la base de datos:
        private void FormPrincipal_Load(object sender, EventArgs e)
        {
            //Conecta a la base de dades:
            FormPrincipal.baseDatos = new BD("root", "", "localhost", "biblioteca");
            FormPrincipal.baseDatos.conecta();
        }

        //Cuando se cierra este form principal (y todo el programa), desconecta de la base de datos:
        private void FormPrincipal_FormClosed(object sender, FormClosedEventArgs e)
        {
            //Desconecta de la base de dades:
            if (FormPrincipal.baseDatos != null) { FormPrincipal.baseDatos.desconecta(); }
        }

    }
}