<?php
	//Funcio que processa el formulari (es crida quan s'ha enviat):
	function processaFormulari()
	{
		global $post, $arxiu_actual;
		
		//Si la matriu esta buida de dades, surt sense processar:
		if (sizeof($post) <= 0) { return; } //lo mateix que if (is_empty($post)).
		else //Si no, processa (else innecessari):
		{
			?>
			<center>
			<b>Resultat del process de matriculaci&oacute;:</b>
			<table border="1" align="center">
				<tr>
					<td>
						<h3>La seva cistella:</h3>
						<b>Articles:</b> <?php echo obtenirArticles($post); ?><br><br>
						<b>Condicions:</b> <?php echo obtenirCondicions($post); ?><br><br>
						<b>Comentaris:</b> <?php echo obtenirComentaris($post); ?><br><br>
						<b>Client:</b> <?php echo obtenirCognoms($post) . ", " . obtenirNom($post); ?><br><br>
					</td>
				</tr>
			</table>
			<form method="post" action="<?php echo $arxiu_actual; ?>">
				<input type="submit" name="boto" value="D'acord" onClick="alert('Dades enviades. Tornem al formulari inicial.');">
				<input type="submit" name="boto" value="Anul&middot;lar" onClick="alert('Dades cancelades. Tornem al formulari inicial.');">
			</form>
			</center>
			<?php
		}
	}
	
	//Funcio que retorna els articles seleccionats:
	function obtenirArticles($post)
	{
		//Si la matriu esta buida de dades, surt retornant una cadena buida:
		if (sizeof($post) <= 0) { return ""; } //lo mateix que if (is_empty($post)).
		else
		{
			$cadena = "";
			
			//Si el o els modems s'han enviat, els guarda en la cadena:
			if (is_array($post["modem"]) > 0)
			{
				foreach ($post["modem"] as $valor)
				{
					$cadena .= $valor . ", ";
				}
			}

			//Si la impressora o impressores s'han enviat, les guarda en la cadena:
			if (is_array($post["impressora"]) > 0)
			{
				foreach ($post["impressora"] as $valor)
				{
					$cadena .= $valor . ", ";
				}
			}
			
			//Guarda en la cadena els consumibles enviats:
			if (isset($post["capsa_disquets"]) && $post["capsa_disquets"] == "si") { $cadena.= "Capsa de disquets, "; }
			if (isset($post["capsa_cd"]) && $post["capsa_cd"] == "si") { $cadena.= "Capsa de cd, "; }
			if (isset($post["cartutx_tinta"]) && $post["cartutx_tinta"] == "si") { $cadena.= "Cartutx de tinta, "; }
			
			//Guarda els "altres" articles en la cadena:
			if (isset($post["webcam"]) && $post["webcam"] == "si") { $cadena.= "Web-Cam, "; }
			if (isset($post["hub"]) && $post["hub"] == "si") { $cadena.= "Hub, "; }

			//Si hi ha coma final, la treu:
			if (trim(substr($cadena, strlen($cadena) - 2)) == ",") { $cadena = substr($cadena, 0, strlen($cadena) - 2); }
			
			if (trim($cadena) == "") { $cadena = "Articles no enviats"; }
			
			return $cadena;
		}
	}
	
	//Funcio que retorna les condicions de pagament:
	function obtenirCondicions($post)
	{
		//Si la matriu esta buida de dades, surt retornant una cadena buida:
		if (sizeof($post) <= 0) { return ""; } //lo mateix que if (is_empty($post)).
		else
		{
			if (isset($post["condicions"]) && $post["condicions"] == "comptat") { $condicions = "Al comptat"; }
			else if (isset($post["condicions"]) && $post["condicions"] == "targeta") { $condicions = "Targeta"; }
			else { $condicions = "Condicio de pagament desconeguda o no enviada"; }
			
			return $condicions;
		}
	}
	
	//Funcio que retorna els comentaris enviats:
	function obtenirComentaris($post)
	{
		//Si la matriu esta buida de dades, surt retornant una cadena buida:
		if (sizeof($post) <= 0) { return ""; } //lo mateix que if (is_empty($post)).
		else
		{
			if (isset($post["comentaris"])) { $comentaris = $post["comentaris"]; }
			if (trim($comentaris) == "") { $comentaris = "Comentaris no enviats"; }
			return $comentaris;
		}
	}
	
	//Funcio que retorna els cognoms enviats:
	function obtenirCognoms($post)
	{
		//Si la matriu esta buida de dades, surt retornant una cadena buida:
		if (sizeof($post) <= 0) { return ""; } //lo mateix que if (is_empty($post)).
		else
		{
			if (isset($post["cognoms"])) { $cognoms = $post["cognoms"]; }
			if (trim($cognoms) == "") { $cognoms = "Cognoms no enviats"; }
			return $cognoms;
		}
	}
	
	//Funcio que retorna el nom enviat:
	function obtenirNom($post)
	{
		//Si la matriu esta buida de dades, surt retornant una cadena buida:
		if (sizeof($post) <= 0) { return ""; } //lo mateix que if (is_empty($post)).
		else
		{
			if (isset($post["nom"])) { $nom = $post["nom"]; }
			if (trim($nom) == "") { $nom = "Nom no enviat"; }
			return $nom;
		}
	}
?>
<html>
	<head>
		<title>Exercici 3</title>
	</head>
	<body bgcolor="#ccddaa">
		<?php
			//Recull les variables enviades per POST i les guarda en una matriu (per fer-les mes accesibles):
			if (isset($HTTP_POST_VARS)) { $post = $HTTP_POST_VARS; }
			else if (isset($_POST)) { $post = $_POST; }
			else { $post = Array(); } //Matriu buida.

			//Si s'ha enviat el formulari, el processa:
			if (isset($post["enviat_ex3"]) && $post["enviat_ex3"] == "si") { processaFormulari(); }
			else //Si no, mostra el formulari:
			{
				//Guarda en una variable el nom del script PHP actual:
				  //Nota: no es molt segur utilitzar PHP_SELF (http://www.nbsp.es/2007/07/18/php_self-%C2%A1peligro-a-la-vista/), pero bueno.	
				if (isset($HTTP_SERVER_VARS["PHP_SELF"])) { $arxiu_actual = $HTTP_SERVER_VARS["PHP_SELF"]; }
				else if (isset($_SERVER["PHP_SELF"])) { $arxiu_actual = $_SERVER["PHP_SELF"]; }
				else if (isset($PHP_SELF)) { $arxiu_actual = $PHP_SELF; }
				else { $arxiu = "ex3.php"; }
		?>
		<center>
		<form method="post" action="<?php echo $arxiu_actual; ?>">
		<input type="hidden" name="enviat_ex3" value="si">
		<table style="border:1px solid black; padding:10px; background:#33cc99;">
			<th>Cistella de compra</th>
			<tr>
				<td style="padding:10px;">
					Cognoms:
				</td>
				<td style="padding:10px;">
					<input type="text" name="cognoms" value="" size="40">
				</td>
				<td style="padding:10px;">
					Nom:
				</td>
				<td style="padding:10px;">
					<input type="text" name="nom" value="" size="40">
				</td>
			</tr>
			<tr>
				<td style="padding:10px;">
					M&ograve;dem:
				</td>
				<td style="padding:10px;">
					<select name="modem[]" multiple>
						<option value="48k">de 48k</option>
						<option value="56k">de 56k</option>
						<option value="adsl">ADSL</option>
						<option value="xdsi">XDSI</option>
					</select>
				</td>
				<td style="padding:10px;">
					Impressora:
				</td>
				<td style="padding:10px;">
					<select name="impressora[]" multiple>
						<option value="epson">Epson</option>
						<option value="epson2">Epson 2</option>
						<option value="kyocera">Kyocera</option>
					</select>
				</td>
			</tr>
			<tr>
				<td style="padding:10px;">
					Consumibles:
				</td>
				<td style="padding:10px;">
					<input type="checkbox" name="capsa_disquets" value="si"> Capsa disquets<br>
					<input type="checkbox" name="capsa_cd" value="si"> Capsa CD<br>
					<input type="checkbox" name="cartutx_tinta" value="si"> Cartutx tinta
				</td>
				<td style="padding:10px;">
					Altres:
				</td>
				<td style="padding:10px;">
					<input type="checkbox" name="webcam" value="si"> Web-Cam<br>
					<input type="checkbox" name="hub" value="si"> Hub
				</td>
			</tr>
			<tr>
				<td style="padding:10px;">
					Condicions:
				</td>
				<td style="padding:10px;">
					<input type="radio" name="condicions" value="comptat">Al comptat<br>
					<input type="radio" name="condicions" value="targeta">Targeta
				</td>
				<td style="padding:10px;">
					Comentaris:
				</td>
				<td style="padding:10px;">
					<textarea name="comentaris"></textarea>
				</td>
			</tr>
			<tr>
				<td cellpadding="2">
					<input type="submit" name="boto" value="Envia">
				</td>
			</td>
		</table>
		</form>
		</center>
	</body>
</html>
<?php
			} //Tanca el else.
?>